/*
 * Decompiled with CFR 0.152.
 */
package com.zzhl.buyer.util;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.CFCAP7Signer;
import cfca.sadk.seal.util.AsyncSignatureUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import com.zzhl.buyer.dto.GetHashCodeDto;
import com.zzhl.buyer.vo.SignHashInfoVo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class GenerateHashUtil {
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();

    public static String getHashCode(GetHashCodeDto dto) throws Exception {
        String signFieldName = dto.getSignFieldName();
        int coordinatePage = dto.getCoordinatePage();
        String signatureReason = dto.getSignatureReason();
        float coordinateTransverse = dto.getCoordinateTransverse().floatValue();
        float coordinateLongitudinal = dto.getCoordinateLongitudinal().floatValue();
        byte[] sealImage = Base64.decode((String)dto.getSealImage());
        String src = dto.getSrc();
        String filePath = src.substring(0, src.lastIndexOf(".")) + "min.pdf";
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setPageNum(coordinatePage);
        appearance.setReason(signatureReason);
        appearance.setSignFieldName(signFieldName);
        appearance.setRectangle(new Rectangle(coordinateLongitudinal, coordinateTransverse, 100.0f, 100.0f));
        appearance.setLocation(dto.getLocation());
        appearance.setStamperSr(sealImage);
        appearance.setTransparency(1.0f);
        appearance.setCenterCoordinate();
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        String x509Data = StringUtils.isBlank((String)dto.getPubCert()) ? "" : dto.getPubCert();
        X509Cert cert = new X509Cert(x509Data.getBytes("UTF8"));
        X509Cert[] chain = new X509Cert[]{cert};
        SignInfoConfig signInfo = new SignInfoConfig();
        signInfo.setSignatureVersion(0);
        signInfo.setSession(session);
        signInfo.setChain(chain);
        if ("01".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SM3_SM2);
        }
        signInfo.setAsyn(true);
        CFCAP7Signer signer = new CFCAP7Signer(signInfo);
        signInfo.setP7Signer((AbstractExternalP7Signer)signer);
        AsyncSignatureUtil.createBlankSignature((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(filePath), (AbstractAppearance)appearance, (SignInfoConfig)signInfo);
        String signhash = Base64.toBase64String((byte[])signer.getHashValue());
        return signhash;
    }

    public static SignHashInfoVo getKeywordHashCode(GetHashCodeDto dto) throws Exception {
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        String src = dto.getSrc();
        Integer len = src.lastIndexOf(".");
        String filePath = src.substring(0, len > 0 ? len.intValue() : src.length()) + "min.pdf";
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setPageNum(0);
        appearance.setReason(dto.getReason());
        if ("12".equals(dto.getSealImageType()) || "24".equals(dto.getSealImageType())) {
            appearance.setRectangle(new Rectangle(45.0f, 45.0f));
        } else if ("11".equals(dto.getSealImageType())) {
            appearance.setRectangle(new Rectangle(100.0f, 100.0f));
        } else {
            appearance.setRectangle(new Rectangle(120.0f, 120.0f));
        }
        appearance.setGSBlendMode(0);
        appearance.setLocation(dto.getLocation());
        appearance.setTransparency(0.8f);
        appearance.setStamperSr(stamperSrc);
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        String x509Data = StringUtils.isBlank((String)dto.getPubCert()) ? "" : dto.getPubCert();
        X509Cert cert = new X509Cert(x509Data.getBytes("UTF8"));
        X509Cert[] chain = new X509Cert[]{cert};
        SignInfoConfig signInfo = new SignInfoConfig();
        signInfo.setSession(session);
        signInfo.setChain(chain);
        if ("01".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SM3_SM2);
        }
        signInfo.setAsyn(true);
        signInfo.setSignatureVersion(0);
        CFCAP7Signer signer = new CFCAP7Signer(signInfo);
        signInfo.setP7Signer((AbstractExternalP7Signer)signer);
        SealResultInfo result = AsyncSignatureUtil.signKeyword((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(filePath), (GraphicAppearance)appearance, (SignInfoConfig)signInfo, (String)dto.getKeyword(), (boolean)true);
        String signhash = Base64.toBase64String((byte[])signer.getHashValue());
        String filed = appearance.getSignFieldName();
        SignHashInfoVo vo = new SignHashInfoVo();
        vo.setSignFieldName(filed);
        vo.setHashCode(signhash);
        vo.setSignType("02");
        return vo;
    }

    public static SignHashInfoVo getBatchSignatureHashCode(GetHashCodeDto dto) throws Exception {
        int page;
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        String src = dto.getSrc();
        String filePath = src.substring(0, src.lastIndexOf(".")) + "min.pdf";
        float coordinateTransverse = dto.getCoordinateTransverse().floatValue();
        float coordinateLongitudinal = dto.getCoordinateLongitudinal().floatValue();
        ArrayList<GraphicAppearance> appearanceList = new ArrayList<GraphicAppearance>();
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setPageNum(dto.getStartPage());
        appearance.setReason("\u5ba1\u6279\u901a\u8fc7,\u540c\u610f\u76d6\u7ae0");
        appearance.setStamperSr(stamperSrc);
        appearance.setRectangle(new Rectangle(coordinateLongitudinal, coordinateTransverse, 0.0f, 0.0f));
        appearance.setGSBlendMode(0);
        appearance.setLocation("\u5317\u4eac");
        appearance.setCenterCoordinate();
        appearance.setTransparency(0.8f);
        appearanceList.add(appearance);
        for (int j = page = dto.getStartPage() + 1; j <= dto.getEndPage(); ++j) {
            GraphicAppearance appearance0 = new GraphicAppearance();
            appearance0.setPageNum(j);
            appearance0.setReason("\u5ba1\u6279\u5b8c\u6210");
            appearance0.setStamperSr(stamperSrc);
            appearance0.setRectangle(new Rectangle(coordinateLongitudinal, coordinateTransverse, 0.0f, 0.0f));
            appearance0.setGSBlendMode(0);
            appearance0.setLocation("\u5317\u4eac");
            appearance0.setTransparency(0.8f);
            appearance0.setCenterCoordinate();
            appearanceList.add(appearance0);
        }
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        String x509Data = StringUtils.isBlank((String)dto.getPubCert()) ? "" : dto.getPubCert();
        X509Cert cert = new X509Cert(x509Data.getBytes("UTF8"));
        X509Cert[] chain = new X509Cert[]{cert};
        SignInfoConfig signInfo = new SignInfoConfig();
        signInfo.setSession(session);
        signInfo.setChain(chain);
        if ("01".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SM3_SM2);
        }
        signInfo.setAsyn(true);
        signInfo.setSignatureVersion(0);
        CFCAP7Signer signer = new CFCAP7Signer(signInfo);
        signInfo.setP7Signer((AbstractExternalP7Signer)signer);
        SealResultInfo result = AsyncSignatureUtil.signCoordinates((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(filePath), appearanceList, (SignInfoConfig)signInfo);
        String signhash = Base64.toBase64String((byte[])signer.getHashValue());
        String filed = appearance.getSignFieldName();
        SignHashInfoVo vo = new SignHashInfoVo();
        vo.setSignFieldName(filed);
        vo.setHashCode(signhash);
        vo.setSignType("03");
        return vo;
    }

    public static SignHashInfoVo getGapSignatureHashCode(GetHashCodeDto dto) throws Exception {
        byte[] stamperSrc = Base64.decode((String)dto.getSealImage());
        String src = dto.getSrc();
        String filePath = src.substring(0, src.lastIndexOf(".")) + "min.pdf";
        float coordinateTransverse = dto.getCoordinateTransverse().floatValue();
        float coordinateLongitudinal = dto.getCoordinateLongitudinal().floatValue();
        System.out.println("\u54c8\u5e0ccoordinateTransverse=" + coordinateTransverse);
        System.out.println("\u54c8\u5e0ccoordinateLongitudinal=" + coordinateLongitudinal);
        GraphicAppearance appearance = new GraphicAppearance();
        appearance.setStartPageNum(-1);
        appearance.setEndPageNum(-1);
        appearance.setReason("\u540c\u610f\u7b7e\u7ae0");
        appearance.setFirstPagePercent(dto.getFirstPagePercent());
        appearance.setLastPagePercent(dto.getLastPagePercent());
        appearance.setRectangle(new Rectangle(coordinateLongitudinal, coordinateTransverse, 100.0f, 100.0f));
        appearance.setMoveCrossPosition(true);
        appearance.setCrossPageStyle(6);
        appearance.setGSBlendMode(0);
        appearance.setStamperSr(stamperSrc);
        appearance.setTransparency(0.7f);
        appearance.setLocation("\u5317\u4eac");
        appearance.setImageFormat("png");
        appearance.setCrossPageRangeOption(0);
        appearance.setDpi(250);
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        String x509Data = StringUtils.isBlank((String)dto.getPubCert()) ? "" : dto.getPubCert();
        X509Cert cert = new X509Cert(x509Data.getBytes("UTF8"));
        X509Cert[] chain = new X509Cert[]{cert};
        SignInfoConfig signInfo = new SignInfoConfig();
        signInfo.setSession(session);
        signInfo.setChain(chain);
        if ("01".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SHA256_RSA);
        } else if ("00".equals(dto.getAlgorithmType())) {
            signInfo.setSignAlg(Mechanisms.M_SM3_SM2);
        }
        signInfo.setAsyn(true);
        CFCAP7Signer signer = new CFCAP7Signer(signInfo);
        signInfo.setP7Signer((AbstractExternalP7Signer)signer);
        SealResultInfo result = AsyncSignatureUtil.signCrossPage((InputStream)new FileInputStream(src), (OutputStream)new FileOutputStream(filePath), (GraphicAppearance)appearance, (SignInfoConfig)signInfo);
        String signhash = Base64.toBase64String((byte[])signer.getHashValue());
        String filed = appearance.getSignFieldName();
        SignHashInfoVo vo = new SignHashInfoVo();
        vo.setSignFieldName(filed);
        vo.setHashCode(signhash);
        vo.setSignType("04");
        return vo;
    }

    static {
        Security.addProvider((Provider)provider);
    }
}

