/*
 * Decompiled with CFR 0.152.
 */
package com.zzhl.buyer.util;

import com.alibaba.fastjson.JSON;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.zzhl.buyer.constant.BaseConfigConstant;
import com.zzhl.buyer.exception.MessageException;
import com.zzhl.buyer.util.GetPlatformConfigUtil;
import com.zzhl.buyer.util.HttpSendUtil;
import com.zzhl.buyer.util.QRUtil;
import com.zzhl.buyer.util.SecretUtil;
import com.zzhl.buyer.util.UuidUtil;
import com.zzhl.buyer.vo.AppResultVo;
import com.zzhl.buyer.vo.QRCodeContentVo;
import com.zzhl.buyer.vo.QRCodeImageVo;
import com.zzhl.http.HttpBuyerSweepCodeUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class GenerateQRCodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpBuyerSweepCodeUtil.class);

    public static QRCodeContentVo getLoginQRCodeContent(String platformCode, String toolCode) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "TId=" + TId + ";" + "QRCodeType=" + "01";
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        String signOriVal = UuidUtil.getUUID();
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "01");
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=01;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo("", TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    public static QRCodeContentVo getLoginQRCodeContent(String platformCode, String toolCode, String allowUserType, String requiredCert) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "TId=" + TId + ";" + "QRCodeType=" + "01";
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        String signOriVal = UuidUtil.getUUID();
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "01");
        paramters.put("allowUserType", allowUserType);
        paramters.put("requiredCert", requiredCert);
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=01;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo("", TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    public static QRCodeContentVo getSignatureQRCodeContent(String platformCode, String toolCode) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "PId=" + TId + ";" + "TId=" + TId + ";" + "QRCodeType=" + "02";
        String signOriVal = UuidUtil.getUUID();
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("PId", TId);
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "02");
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=02;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo(TId, TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    public static QRCodeContentVo getWithdrawQRCodenContent(String platformCode, String toolCode, String signCertSn) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "TId=" + TId + ";" + "QRCodeType=" + "03";
        String signOriVal = UuidUtil.getUUID();
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "03");
        paramters.put("signCertSn", signCertSn);
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=03;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode + ";signCertSn=" + signCertSn);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo("", TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    public static QRCodeContentVo getChangeQRCodeContent(String platformCode, String toolCode, String orgId) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "PId=" + TId + ";" + "TId=" + TId + ";" + "QRCodeType=" + "04";
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        String signOriVal = UuidUtil.getUUID();
        paramters.put("PId", TId);
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "04");
        paramters.put("orgId", orgId);
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=04;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode + ";orgId=" + orgId);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo(TId, TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    public static QRCodeContentVo getAuthQRCodeContent(String platformCode, String toolCode) throws Exception {
        platformCode = GetPlatformConfigUtil.getPlatformCode(platformCode);
        String TId = platformCode + UuidUtil.getUUID();
        String qrcodeContent = "PId=" + TId + ";" + "TId=" + TId + ";" + "QRCodeType=" + "05";
        String signOriVal = UuidUtil.getUUID();
        String encodeContent = GenerateQRCodeUtil.generateEncodeContent(qrcodeContent);
        HashMap<String, Object> paramters = new HashMap<String, Object>();
        paramters.put("PId", TId);
        paramters.put("TId", TId);
        paramters.put("QRCodeType", "05");
        paramters.put("signOriVal", signOriVal);
        paramters.put("platformCode", platformCode);
        paramters.put("toolCode", toolCode);
        paramters.put("qrcodeContent", encodeContent);
        paramters.put("serviceCode", BaseConfigConstant.serviceCode);
        logger.info("QRCodeType=05;TId=" + TId + ";signOriVal=" + signOriVal + ";platformCode=" + platformCode + ";toolCode=" + toolCode + ";serviceCode=" + BaseConfigConstant.serviceCode);
        String res = HttpSendUtil.sendToBuyerServer("ctepapp/scanning/setQrcodeDetail", paramters, null);
        AppResultVo result = (AppResultVo)JSON.parseObject((String)res, AppResultVo.class);
        String returnCode = result.getHeader().get("returnCode");
        if (!"0".equals(returnCode)) {
            String message = result.getHeader().get("msg");
            throw new MessageException(message);
        }
        QRCodeImageVo imageVo = GenerateQRCodeUtil.getQRCodeImageBase64(encodeContent);
        QRCodeContentVo vo = new QRCodeContentVo(TId, TId, encodeContent, imageVo.getQrCodeImageBase64());
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage generateQRCodeImage(String qrcodeContent) {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = null;
        BufferedImage image = null;
        ClassPathResource resource = null;
        Graphics g = null;
        try {
            bitMatrix = multiFormatWriter.encode(qrcodeContent, BarcodeFormat.QR_CODE, 800, 800);
            image = QRUtil.toBufferedImage(bitMatrix);
            String logoPath = "static/images/sign_icon.png";
            resource = new ClassPathResource(logoPath);
            if (resource.isReadable()) {
                InputStream inputStream = resource.getInputStream();
                g = image.createGraphics();
                BufferedImage logo = ImageIO.read(inputStream);
                int width = image.getWidth() * 5 / 30;
                int logoWidth = logo.getWidth();
                int logoHeight = logo.getHeight() * width / logoWidth;
                int x = (image.getWidth() - width) / 2;
                int y = (image.getHeight() - logoHeight) / 2;
                g.drawImage(logo, x, y, width, logoHeight, null);
                logo.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != g) {
                g.dispose();
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QRCodeImageVo getQRCodeImageBase64(String qrcodeContent) {
        QRCodeImageVo vo = new QRCodeImageVo();
        ByteArrayOutputStream out = null;
        BufferedImage image = GenerateQRCodeUtil.generateQRCodeImage(qrcodeContent);
        try {
            out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", out);
            byte[] b = out.toByteArray();
            vo.setQrCodeImageBase64(Base64.encodeBase64String((byte[])b));
            QRCodeImageVo qRCodeImageVo = vo;
            return qRCodeImageVo;
        }
        catch (Exception e) {
            System.out.println("\u7ed8\u5236\u4e8c\u7ef4\u7801\u56fe\u7247\u4e2d\u5fc3logo\u5931\u8d25\uff1a" + e);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                System.out.println("\u751f\u6210\u4e8c\u7ef4\u7801\u56fe\u7247\u5173\u95ed\u8f93\u51fa\u6d41\uff1a" + e);
            }
        }
        return null;
    }

    private static String generateEncodeContent(String content) throws Exception {
        String base64Content = "key=" + SecretUtil.encryptByAES(BaseConfigConstant.AES_SECRET_KEY_FOR_APP, content);
        return BaseConfigConstant.yyzxUrl + "?" + Base64.encodeBase64String((byte[])base64Content.getBytes());
    }
}

