/*
 * Decompiled with CFR 0.152.
 */
package com.zzhl.http;

import cfca.sadk.seal.base.bean.sign.RevokeResultInfo;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.RevokeUtil;
import cfca.sadk.system.FileHelper;
import com.zzhl.buyer.dto.BuyerSealImageDto;
import com.zzhl.buyer.dto.CombineSignDto;
import com.zzhl.buyer.dto.GetHashCodeDto;
import com.zzhl.buyer.dto.SetCloudCertHashListSignInfoDto;
import com.zzhl.buyer.dto.SetCloudCertInfoDto;
import com.zzhl.buyer.dto.SignHashListDto;
import com.zzhl.buyer.util.CallBuyerServerUtil;
import com.zzhl.buyer.util.CombineSignUtil;
import com.zzhl.buyer.util.GenerateHashUtil;
import com.zzhl.buyer.util.GenerateQRCodeUtil;
import com.zzhl.buyer.vo.CloudSignCertVo;
import com.zzhl.buyer.vo.CloudSignValueListVo;
import com.zzhl.buyer.vo.QRCodeContentVo;
import com.zzhl.buyer.vo.SealImageVo;
import com.zzhl.buyer.vo.SignHashInfoVo;
import com.zzhl.buyer.vo.UserOrgVo;
import com.zzhl.buyer.vo.WithdrawSealVo;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuyerSweepCodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpBuyerSweepCodeUtil.class);

    public static QRCodeContentVo getLoginQRCodeContent(String platformCode, String toolCode) throws Exception {
        return GenerateQRCodeUtil.getLoginQRCodeContent(platformCode, toolCode);
    }

    public static QRCodeContentVo getChangeQRCodeContent(String platformCode, String toolCode, String orgId) throws Exception {
        return GenerateQRCodeUtil.getChangeQRCodeContent(platformCode, toolCode, orgId);
    }

    public static QRCodeContentVo getAuthQRCodeContent(String platformCode, String toolCode) throws Exception {
        return GenerateQRCodeUtil.getAuthQRCodeContent(platformCode, toolCode);
    }

    public static QRCodeContentVo getSignatureQRCodeContent(String platformCode, String toolCode) throws Exception {
        return GenerateQRCodeUtil.getSignatureQRCodeContent(platformCode, toolCode);
    }

    public static QRCodeContentVo getWithdrawQRCodenContent(String platformCode, String toolCode, String signCertSn) throws Exception {
        return GenerateQRCodeUtil.getWithdrawQRCodenContent(platformCode, toolCode, signCertSn);
    }

    public static BufferedImage generateQRCodeImage(String qrcodeContent) throws Exception {
        return GenerateQRCodeUtil.generateQRCodeImage(qrcodeContent);
    }

    public static List<SealImageVo> getSealImageListInfo(BuyerSealImageDto buyerSealImageDto) throws Exception {
        List<SealImageVo> sealImageList = CallBuyerServerUtil.getSealImageList(buyerSealImageDto);
        return sealImageList;
    }

    public static List<UserOrgVo> getUserOrgList(String allowUserType, String accessToken) throws Exception {
        List<UserOrgVo> userOrgList = CallBuyerServerUtil.getUserOrgList(allowUserType, accessToken);
        return userOrgList;
    }

    public static WithdrawSealVo getWithdrawSealSignature(String signCertSn, String accessToken) throws Exception {
        WithdrawSealVo withdrawSealVo = CallBuyerServerUtil.getWithdrawSealSignature(signCertSn, accessToken);
        return withdrawSealVo;
    }

    public static WithdrawSealVo getWithdrawSealSignatureByH5(String signCertSn, String idNumber) throws Exception {
        WithdrawSealVo withdrawSealVo = CallBuyerServerUtil.getWithdrawSealSignatureByH5(signCertSn, idNumber);
        return withdrawSealVo;
    }

    public static Boolean synthesisSignature(CombineSignDto dto) throws Exception {
        Boolean synthesisSignature = CombineSignUtil.synthesisSignature(dto);
        return synthesisSignature;
    }

    public static Boolean batchSynthesisSignature(CombineSignDto dto) throws Exception {
        Boolean synthesisSignature = CombineSignUtil.batchSynthesisSignature(dto);
        return synthesisSignature;
    }

    public static Boolean synthesisSignatureKeyword(CombineSignDto dto) throws Exception {
        Boolean synthesisSignature = CombineSignUtil.synthesisSignatureKeyword(dto);
        return synthesisSignature;
    }

    public static Boolean gapSynthesisSignature(CombineSignDto dto) throws Exception {
        Boolean synthesisSignature = CombineSignUtil.gapSynthesisSignature(dto);
        return synthesisSignature;
    }

    public static String getHashCode(GetHashCodeDto dto) throws Exception {
        return GenerateHashUtil.getHashCode(dto);
    }

    public static SignHashInfoVo getBatchSignatureHashCode(GetHashCodeDto dto) throws Exception {
        return GenerateHashUtil.getBatchSignatureHashCode(dto);
    }

    public static SignHashInfoVo getKeywordHashCode(GetHashCodeDto dto) throws Exception {
        return GenerateHashUtil.getKeywordHashCode(dto);
    }

    public static SignHashInfoVo getGapSignatureHashCode(GetHashCodeDto dto) throws Exception {
        return GenerateHashUtil.getGapSignatureHashCode(dto);
    }

    public static void setExitNotice(String pid, String tid, String exitReason, String token) throws Exception {
        CallBuyerServerUtil.setExitNotice(pid, tid, exitReason, token);
    }

    public static String setSignHashList(SignHashListDto dto) throws Exception {
        return CallBuyerServerUtil.setSignHashList(dto);
    }

    public static void platformSetCloudSignHashList(SetCloudCertHashListSignInfoDto dto) throws Exception {
        CallBuyerServerUtil.platformSetCloudSignHashList(dto);
    }

    public static CloudSignValueListVo platformSetCloudSignHashListSync(SetCloudCertHashListSignInfoDto dto) throws Exception {
        return CallBuyerServerUtil.platformSetCloudSignHashListSync(dto);
    }

    public static String platformSetCloudCertInfo(SetCloudCertInfoDto dto) throws Exception {
        return CallBuyerServerUtil.platformSetCloudCertInfo(dto);
    }

    public static CloudSignCertVo platformSetCloudCertInfoSync(SetCloudCertInfoDto dto) throws Exception {
        return CallBuyerServerUtil.platformSetCloudCertInfoSync(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean keywordIsExistByPath(String path, String keyword) throws Exception {
        boolean exists = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            HashMap locationExtraction = PDFUtil.locationExtraction((InputStream)in, (String)keyword);
            exists = null != locationExtraction && !locationExtraction.entrySet().isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                ((InputStream)in).close();
            }
        }
        return exists;
    }

    public static RevokeResultInfo revokeLastSignature(String path, String signatureValue) throws Exception {
        String inputFileName = path;
        String secondFileName = path;
        byte[] sourceData = FileHelper.read((String)inputFileName);
        RevokeResultInfo revokeLastSignature = RevokeUtil.revokeLastSignature((InputStream)new ByteArrayInputStream(sourceData), (OutputStream)new FileOutputStream(secondFileName));
        return revokeLastSignature;
    }

    public static CloudSignCertVo getCloudCertSealInfo(SetCloudCertInfoDto dto) throws Exception {
        return CallBuyerServerUtil.getCloudCertSealInfo(dto);
    }

    public static CloudSignValueListVo setCloudSignHashListSync(SetCloudCertHashListSignInfoDto dto) throws Exception {
        return CallBuyerServerUtil.setCloudSignHashListSync(dto);
    }
}

