/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.dubbo.internal;

import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import com.alibaba.dubbo.common.utils.ClassHelper;
import com.alibaba.dubbo.common.utils.PojoUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;

public class DubboRequest
implements Serializable {
    private static final long serialVersionUID = -2566117630720665393L;
    public static final DubboRequest DUBBO_LOOKUP_REQUEST = new DubboRequest("com.alibaba.dubbo.DubboService", "0.0.0", "lookup", new String[0], new Object[0]);
    private String sName;
    private String sVersion;
    private String mName;
    private String[] ptNames;
    private transient Class<?>[] paramTypes;
    private transient Object[] parameters;
    private transient AbstractHessianInput paramInputStream;
    private transient byte[] rawData;
    private transient int offset;

    public DubboRequest() {
    }

    public DubboRequest(String serviceName, String serviceVersion, Method method, Object[] args) {
        this.sName = serviceName;
        this.sVersion = serviceVersion;
        this.mName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length > 0) {
            this.ptNames = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this.ptNames[i] = paramTypes[i].getName();
            }
        }
        this.parameters = args;
    }

    public DubboRequest(String serviceName, String serviceVersion, String mName, String[] ptNames, Object[] args) {
        this.sName = serviceName;
        this.sVersion = serviceVersion;
        this.mName = mName;
        this.ptNames = ptNames;
        this.parameters = args;
    }

    public String getServiceName() {
        return this.sName;
    }

    public String getMethodName() {
        return this.mName;
    }

    public String[] getParamTypeNames() {
        return this.ptNames == null ? new String[]{} : this.ptNames;
    }

    public Object[] getParameters() {
        return this.parameters == null ? new Object[]{} : this.parameters;
    }

    public Class<?>[] resolveParamTypes(ClassLoader cl) throws ClassNotFoundException {
        if (this.paramTypes == null) {
            if (this.ptNames != null && this.ptNames.length > 0) {
                if (cl == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                this.paramTypes = new Class[this.ptNames.length];
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    Class<?> paramType = ClassHelper.resolvePrimitiveClassName(this.ptNames[i]);
                    if (paramType == null) {
                        paramType = ClassHelper.forName(this.ptNames[i], cl);
                    }
                    this.paramTypes[i] = paramType;
                }
            } else {
                this.paramTypes = new Class[0];
            }
        }
        return this.paramTypes;
    }

    public void setParameters(Object[] args) {
        this.parameters = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] readParameters(ClassLoader cl) throws IOException, ClassNotFoundException {
        if (this.parameters == null && this.paramInputStream != null) {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            try {
                Class<?>[] paramTypes = this.resolveParamTypes(cl);
                Object[] params = new Object[paramTypes.length];
                this.paramInputStream.setSerializerFactory(new SerializerFactory(cl));
                for (int i = 0; i < paramTypes.length; ++i) {
                    params[i] = this.paramInputStream.readObject(paramTypes[i]);
                }
                this.parameters = params;
            }
            finally {
                this.close();
            }
        }
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] readParameters(ClassLoader cl, boolean general) throws IOException, ClassNotFoundException {
        if (this.parameters == null && this.paramInputStream != null) {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            try {
                Class<?>[] paramTypes = this.resolveParamTypes(cl);
                Object[] params = new Object[paramTypes.length];
                this.paramInputStream.setSerializerFactory(new SerializerFactory(cl));
                for (int i = 0; i < paramTypes.length; ++i) {
                    params[i] = general && PojoUtils.isPojo(paramTypes[i]) ? this.paramInputStream.readObject() : this.paramInputStream.readObject(paramTypes[i]);
                }
                this.parameters = params;
            }
            finally {
                this.close();
            }
        }
        return this.parameters;
    }

    public void setParamInputStream(AbstractHessianInput in) {
        this.paramInputStream = in;
    }

    public void setRawData(byte[] data, int offset) {
        this.rawData = data;
        this.offset = offset;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getServiceVersion() {
        return this.sVersion;
    }

    public void close() {
        if (this.paramInputStream != null) {
            try {
                this.paramInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.paramInputStream = null;
        }
    }

    public String toString() {
        return this.sName + ":" + this.sVersion + "." + this.mName + "()";
    }
}

