/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.http.HttpServer;
import com.alibaba.dubbo.rpc.http.InternalHttpRpcExporter;
import com.alibaba.dubbo.rpc.http.ServiceDispatcherServlet;
import com.alibaba.dubbo.rpc.http.ServletHttpServer;
import com.alibaba.dubbo.rpc.http.support.DefaultHttpInvocationCodec;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpProtocol {
    private static final Logger logger = LoggerInit.LOGGER;
    private static final Map<String, HttpServer> mServerMap = new ConcurrentHashMap<String, HttpServer>();
    private static final HttpProtocol INSTANCE = new HttpProtocol();

    private HttpProtocol() {
    }

    public static HttpProtocol getInstance() {
        return INSTANCE;
    }

    public <T> void export(URL url, Class<T> interfaceClass, Object target) throws RpcException {
        String codec;
        String uri = url.getPath();
        String addr = url.getHost() + ":" + url.getPort();
        HttpServer server = mServerMap.get(addr);
        if (server == null) {
            String type = url.getParameter("server", "servlet");
            if (type != null && type.length() != 0 && !"servlet".equals(type)) {
                throw new IllegalArgumentException("Unsupported http server " + type + ", only support servlet!");
            }
            server = new ServletHttpServer(url.getPort());
            server.start();
            mServerMap.put(addr, server);
        }
        if ((codec = url.getParameter("serialization")) != null && codec.length() > 0) {
            DefaultHttpInvocationCodec.getContentTypeByCodec(codec);
        }
        InternalHttpRpcExporter<T> exporter = new InternalHttpRpcExporter<T>(interfaceClass, target);
        ServiceDispatcherServlet.addProcessor(url.getPort(), uri, exporter);
    }

    public void destroy() {
        for (String key : new ArrayList<String>(mServerMap.keySet())) {
            HttpServer server = mServerMap.remove(key);
            if (server == null) continue;
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("Close http server 0.0.0.0:" + server.getPort());
                }
                server.stop();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), new Object[]{t});
            }
        }
    }
}

