/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.http.HttpProcessor;
import com.alibaba.dubbo.rpc.http.support.DefaultHttpInvocationCodec;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InternalHttpRpcExporter<T>
implements HttpProcessor {
    private static final DefaultHttpInvocationCodec mCodec = new DefaultHttpInvocationCodec();
    private Class<T> interfaceClass;
    private Object target;

    public InternalHttpRpcExporter(Class<T> interfaceClass, Object target) {
        this.interfaceClass = interfaceClass;
        this.target = target;
    }

    @Override
    public void invoke(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Invocation inv;
        try {
            inv = mCodec.decodeInvocation(this.interfaceClass, req);
        }
        catch (IOException e) {
            throw new RpcException("Decode invocation data failed.", (Throwable)e);
        }
        Result result = this.doInvoke(inv);
        mCodec.encodeResult(result, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result doInvoke(Invocation inv) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.target.getClass().getClassLoader());
            Method method = this.target.getClass().getMethod(inv.getMethodName(), inv.getParameterTypes());
            Object result = method.invoke(this.target, inv.getArguments());
            RpcResult rpcResult = new RpcResult(result);
            return rpcResult;
        }
        catch (Throwable e) {
            RpcResult rpcResult = new RpcResult(e);
            return rpcResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }
}

