/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.dubbo.common.serialize.support.java.CompactedObjectInputStream;
import com.alibaba.dubbo.common.serialize.support.java.CompactedObjectOutputStream;
import com.alibaba.dubbo.rpc.http.codec.StreamCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompactedJavaCodec
extends StreamCodec {
    @Override
    public String getName() {
        return "compactedjava";
    }

    @Override
    public void encode(OutputStream output, Object value) throws IOException {
        CompactedObjectOutputStream oos = new CompactedObjectOutputStream(output);
        oos.writeObject(value);
        oos.flush();
    }

    @Override
    public Object decode(InputStream input, Class<?> type) throws IOException {
        CompactedObjectInputStream ois = new CompactedObjectInputStream(input);
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void encode(OutputStream output, Object[] value) throws IOException {
        CompactedObjectOutputStream oos = new CompactedObjectOutputStream(output);
        for (Object obj : value) {
            oos.writeObject(obj);
        }
        oos.flush();
    }

    @Override
    public Object[] decode(InputStream input, Class<?>[] types) throws IOException {
        CompactedObjectInputStream ois = new CompactedObjectInputStream(input);
        Object[] ret = new Object[types.length];
        try {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = ois.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        return ret;
    }
}

