/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.dubbo.rpc.http.codec.MapCodec;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormCodec
extends MapCodec {
    public static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static Pattern QUERY_PATTERN = Pattern.compile("([&=]?)\\s*([^&=\\s]+)");

    @Override
    public String getName() {
        return "form";
    }

    @Override
    public String getContentType() {
        return FORM_CONTENT_TYPE;
    }

    @Override
    public void encode(Writer writer, Object value) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            FormCodec.encodeValue(sb, value, "");
            writer.write(sb.toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void encode(Writer writer, Object[] value) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            FormCodec.encodeValues(sb, value, "");
            writer.write(sb.toString());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Object decode(Reader reader, Class<?> type) throws IOException {
        try {
            return FormCodec.decodeValue(type, FormCodec.parseQuery(reader), "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Object decode(Reader reader, Class<?>[] type) throws IOException {
        try {
            return FormCodec.decodeValues(type, FormCodec.parseQuery(reader), "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static void encodeValues(StringBuilder sb, Object[] value, String property) throws Exception {
        if (value == null || value.length == 0) {
            return;
        }
        for (int i = 0; i < value.length; ++i) {
            FormCodec.encodeValue(sb, Array.get(value, i), i == 0 ? "" : String.valueOf(i));
        }
    }

    private static void encodeValue(StringBuilder sb, Object value, String property) throws Exception {
        if (value == null) {
            return;
        }
        Class<?> type = value.getClass();
        if (FormCodec.isPrimitive(type)) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(property != null && property.length() > 0 ? property : "0");
            sb.append("=");
            sb.append(value);
        } else if (type.isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                FormCodec.encodeValue(sb, Array.get(value, i), property);
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)value;
            for (Object item : collection) {
                FormCodec.encodeValue(sb, item, property);
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                FormCodec.encodeValue(sb, entry.getValue(), property != null && property.length() > 0 ? property + "." + key : key);
            }
        } else {
            Map<String, Object> properties = FormCodec.getProperties(value);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                FormCodec.encodeValue(sb, entry.getValue(), property != null && property.length() > 0 ? property + "." + entry.getKey() : entry.getKey());
            }
        }
    }

    @Override
    public void encode(Map<String, String[]> output, Object value) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            FormCodec.encodeValue(sb, value, "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void encode(Map<String, String[]> output, Object[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            FormCodec.encodeValues(sb, value, "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static Object[] decodeValues(Class<?>[] type, Map<String, String[]> params, String property) throws Exception {
        Object[] ret = new Object[type.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FormCodec.decodeValue(type[i], params, i == 0 ? "" : String.valueOf(i));
        }
        return ret;
    }

    private static Object decodeValue(Class<?> type, Map<String, String[]> params, String property) throws Exception {
        if (FormCodec.isPrimitive(type)) {
            String[] values = FormCodec.getParameter(params, property);
            return FormCodec.convertValue(values == null || values.length == 0 ? null : values[0], type);
        }
        if (type.isArray()) {
            String[] values = FormCodec.getParameter(params, property);
            Class<?> comp = type.getComponentType();
            int length = values == null ? 0 : values.length;
            Object array = Array.newInstance(comp, length);
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    Object value = FormCodec.convertValue(values[i], comp);
                    Array.set(array, i, value);
                }
            }
            return array;
        }
        if (Collection.class.isAssignableFrom(type)) {
            ArrayList<String> collection;
            int length;
            String[] values = FormCodec.getParameter(params, property);
            int n = length = values == null ? 0 : values.length;
            Collection<String> collection2 = type == Collection.class || type == List.class ? new ArrayList<String>() : (collection = type == Set.class ? new HashSet() : (Collection)type.newInstance());
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    collection.add(values[i]);
                }
            }
            return collection;
        }
        if (Map.class.isAssignableFrom(type)) {
            HashMap<String, Object[]> map;
            Map<String, String[]> sub = FormCodec.getSubParameterMap(params, property != null && property.length() > 0 ? property + "." : "");
            Map<String, Object> map2 = type == Map.class ? new HashMap<String, Object[]>() : (map = type == ConcurrentMap.class ? new ConcurrentHashMap() : (Map)type.newInstance());
            if (sub != null && sub.size() > 0) {
                for (Map.Entry<String, String[]> entry : sub.entrySet()) {
                    Object value;
                    String[] values = entry.getValue();
                    if (values == null || values.length <= 0) continue;
                    String key = entry.getKey();
                    if (values.length == 1) {
                        value = FormCodec.convertValue(values[0]);
                    } else {
                        int i;
                        Object[] vs = new Object[values.length];
                        Class<?> t = null;
                        boolean same = true;
                        for (i = 0; i < values.length; ++i) {
                            vs[i] = FormCodec.convertValue(values[i]);
                            if (vs[i] == null) continue;
                            Class<?> c = vs[i].getClass();
                            if (t == null) {
                                t = c;
                                continue;
                            }
                            if (c == t) continue;
                            same = false;
                        }
                        if (same) {
                            value = Array.newInstance(t, vs.length);
                            for (i = 0; i < vs.length; ++i) {
                                Array.set(value, i, vs[i]);
                            }
                        } else {
                            value = vs;
                        }
                    }
                    map.put(key, (Object[])value);
                }
            }
            return map;
        }
        Object obj = type.newInstance();
        for (Method method : type.getMethods()) {
            String name = method.getName();
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1 || name.length() <= 3 || !name.startsWith("set")) continue;
            String p = name.substring(3, 4).toLowerCase() + name.substring(4);
            Class<?> t = method.getParameterTypes()[0];
            Object value = FormCodec.decodeValue(t, params, property != null && property.length() > 0 ? property + "." + p : p);
            method.invoke(obj, value);
        }
        return obj;
    }

    @Override
    public Object decode(Map<String, String[]> input, Class<?> type) throws IOException {
        try {
            return FormCodec.decodeValue(type, input, "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Object[] decode(Map<String, String[]> input, Class<?>[] types) throws IOException {
        try {
            return FormCodec.decodeValues(types, input, "");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static Map<String, String[]> getSubParameterMap(Map<String, String[]> params, String prefix) {
        if (params == null) {
            return null;
        }
        if (prefix == null || prefix.length() == 0) {
            return params;
        }
        int len = prefix.length();
        HashMap<String, String[]> sub = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.length() <= len || !key.startsWith(prefix)) continue;
            sub.put(key.substring(len), entry.getValue());
        }
        return sub;
    }

    private static String[] getParameter(Map<String, String[]> params, String property) {
        String[] values;
        if (property == null || property.length() == 0) {
            property = "0";
        }
        if ((values = params.get(property)) == null || values.length == 0) {
            if (!property.matches("^\\d+\\.")) {
                values = params.get("0." + property);
            }
            if ((values == null || values.length == 0) && "0".equals(property) && params.size() > 0) {
                values = params.values().iterator().next();
            }
        }
        return values;
    }

    private static boolean isPrimitive(Class<?> type) throws Exception {
        return type.isPrimitive() || type.isEnum() || type == Boolean.class || type == Character.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class || type == Date.class;
    }

    private static Object convertValue(String value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value.matches("^[+\\-]?\\d+$")) {
            if (value.length() > 10) {
                return Long.valueOf(value);
            }
            return Integer.valueOf(value);
        }
        if (value.matches("^[+\\-]?\\d*\\.\\d{1,2}$")) {
            return Float.valueOf(value);
        }
        if (value.matches("^[+\\-]?\\d*\\.\\d+$")) {
            return Double.valueOf(value);
        }
        return value;
    }

    private static Object convertValue(String value, Class<?> type) throws Exception {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return value == null || value.length() == 0 ? false : Boolean.parseBoolean(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(value == null || value.length() == 0 ? (char)'\u0000' : value.charAt(0));
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return value == null || value.length() == 0 ? (byte)0 : Byte.parseByte(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return value == null || value.length() == 0 ? (short)0 : Short.parseShort(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return value == null || value.length() == 0 ? 0 : Integer.parseInt(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return value == null || value.length() == 0 ? 0L : Long.parseLong(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(value == null || value.length() == 0 ? 0.0f : Float.parseFloat(value));
        }
        if (type == Double.TYPE || type == Double.class) {
            return value == null || value.length() == 0 ? 0.0 : Double.parseDouble(value);
        }
        if (type == Date.class) {
            return value == null || value.length() == 0 ? null : FormCodec.parseDate(value);
        }
        if (type.isEnum()) {
            return value == null || value.length() == 0 ? null : Enum.valueOf(type, value);
        }
        return value;
    }

    private static Date parseDate(String value) throws ParseException {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd").parse(value);
            }
            catch (ParseException e1) {
                return new SimpleDateFormat("HH:mm:ss").parse(value);
            }
        }
    }

    private static Map<String, String[]> parseQuery(Reader reader) throws IOException {
        String query = FormCodec.readToString(reader);
        Matcher matcher = QUERY_PATTERN.matcher(query);
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        String key = null;
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (separator == null || separator.length() == 0 || "&".equals(separator)) {
                if (key != null) {
                    throw new IllegalStateException("Illegal route rule \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
                }
                key = content;
                continue;
            }
            if ("=".equals(separator)) {
                if (key == null) {
                    throw new IllegalStateException("Illegal route rule \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
                }
                ArrayList<String> list = (ArrayList<String>)params.get(key);
                if (list == null) {
                    list = new ArrayList<String>();
                    params.put(key, list);
                }
                list.add(content);
                key = null;
                continue;
            }
            if (key != null) continue;
            throw new IllegalStateException("Illegal route rule \"" + query + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".");
        }
        if (key != null) {
            throw new IllegalStateException("Illegal route rule \"" + query + "\", The error in the end char: " + key);
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            result.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return result;
    }

    private static String readToString(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[8192];
        int len = 0;
        while ((len = reader.read(buf)) != -1) {
            buffer.append(buf, 0, len);
        }
        return buffer.toString();
    }

    private static Map<String, Object> getProperties(Object object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> cls = object.getClass();
        if (cls != null && Modifier.isPublic(cls.getModifiers())) {
            Method[] methods = cls.getMethods();
            int n = methods.length;
            for (int i = 0; i < n; ++i) {
                try {
                    Method method = methods[i];
                    if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass() == Object.class || method.getReturnType() == Void.class || method.getParameterTypes().length != 0) continue;
                    String property = null;
                    String methodName = method.getName();
                    if (methodName.startsWith("get")) {
                        property = methodName.substring(3);
                    } else if (methodName.startsWith("is")) {
                        property = methodName.substring(2);
                    }
                    if (property == null) continue;
                    String lower = property.substring(0, 1).toLowerCase() + property.substring(1);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    map.put(lower, method.invoke(object, new Object[0]));
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return map;
    }
}

