/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.codec.support;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.alibaba.dubbo.rpc.http.codec.StreamCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Hessian2Codec
extends StreamCodec {
    @Override
    public String getName() {
        return "hessian2";
    }

    @Override
    public void encode(OutputStream output, Object value) throws IOException {
        Hessian2Output h2o = new Hessian2Output(output);
        h2o.writeObject(value);
        h2o.flush();
    }

    @Override
    public Object decode(InputStream input, Class<?> type) throws IOException {
        Hessian2Input h2i = new Hessian2Input(input);
        return h2i.readObject(type);
    }

    @Override
    public void encode(OutputStream output, Object[] value) throws IOException {
        Hessian2Output h2o = new Hessian2Output(output);
        for (Object obj : value) {
            h2o.writeObject(obj);
        }
        h2o.flush();
    }

    @Override
    public Object[] decode(InputStream input, Class<?>[] types) throws IOException {
        Hessian2Input h2i = new Hessian2Input(input);
        Object[] ret = new Object[types.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = h2i.readObject(types[i]);
        }
        return ret;
    }
}

