/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.support;

import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.http.HttpInvocationCodec;
import com.alibaba.dubbo.rpc.http.codec.Codec;
import com.alibaba.dubbo.rpc.http.codec.MapCodec;
import com.alibaba.dubbo.rpc.http.codec.StreamCodec;
import com.alibaba.dubbo.rpc.http.codec.TextCodec;
import com.alibaba.dubbo.rpc.http.codec.support.FormCodec;
import com.alibaba.dubbo.rpc.http.support.Service;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultHttpInvocationCodec
implements HttpInvocationCodec {
    private static final Logger logger = LoggerInit.LOGGER;
    public static final String HTTP_HEADER_METHOD_NAME = "Method-Name";
    public static final String HTTP_HEADER_PARAMETER_TYPES = "Parameter-Types";
    public static final String HTTP_HEADER_EXCEPTION_TYPE = "Exception-Type";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<String, String> CODEC_NAME_TYPE_MAP = new HashMap<String, String>();
    private static final Codec<?, ?> DEFAULT_CODEC = new FormCodec();
    private static final Map<String, Codec<?, ?>> TYPE_CODEC_MAP = new HashMap();

    static String[] getContentTypeAndCharset(HttpServletRequest req) {
        int ix;
        String ct = req.getContentType();
        String cs = req.getCharacterEncoding();
        if (ct != null && ct.length() > 0 && (ix = ct.indexOf(59)) > 0) {
            cs = ct.substring(ix + 1).trim().substring(8);
            ct = ct.substring(0, ix);
        }
        if (cs == null || cs.length() == 0) {
            cs = "UTF-8";
        }
        return new String[]{ct, cs};
    }

    public Invocation decodeInvocation(Class<?> interfaceClass, HttpServletRequest req) throws IOException {
        Class<?>[] pts;
        String desc;
        String method;
        String uri = req.getRequestURI();
        String contentType = req.getContentType();
        if (contentType == null || "application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
            int j;
            method = uri;
            int i = method.lastIndexOf(47);
            if (i != -1) {
                method = method.substring(i + 1);
            }
            if ((j = method.lastIndexOf(46)) != -1) {
                method = method.substring(0, j);
            }
            try {
                desc = ReflectUtils.getDesc(ReflectUtils.findMethodByMethodName(interfaceClass, method).getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IOException(StringUtils.toString(e));
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.toString(e));
            }
        } else {
            method = req.getHeader(HTTP_HEADER_METHOD_NAME);
            desc = req.getHeader(HTTP_HEADER_PARAMETER_TYPES);
        }
        if (method == null || method.length() == 0) {
            throw new IOException("Missing Method-Name header.");
        }
        if (desc == null) {
            throw new IOException("Missing Parameter-Types header.");
        }
        try {
            pts = ReflectUtils.desc2classArray(desc);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString(e));
        }
        String[] cts = DefaultHttpInvocationCodec.getContentTypeAndCharset(req);
        Object[] args = this.decodeArguments(pts, cts[0], cts[1], req);
        return new RpcInvocation(method, pts, args);
    }

    protected Object[] decodeArguments(Class<?>[] pts, String contentType, String charset, HttpServletRequest is) throws IOException {
        if (pts.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Codec<?, ?> protocol = this.acceptContentType(contentType);
        if (logger.isDebugEnabled()) {
            logger.debug("Http protocol codec flag: " + protocol + ", contentType: " + contentType);
        }
        if (protocol == null) {
            throw new IOException("Unsupported contentType: " + contentType);
        }
        if (protocol instanceof StreamCodec) {
            StreamCodec c = (StreamCodec)protocol;
            return c.decode((InputStream)is.getInputStream(), pts);
        }
        if (protocol instanceof TextCodec) {
            TextCodec c = (TextCodec)protocol;
            return c.decode((Reader)is.getReader(), pts);
        }
        if (protocol instanceof MapCodec) {
            MapCodec c = (MapCodec)protocol;
            Map input = is.getParameterMap();
            return c.decode((Map<String, String[]>)input, pts);
        }
        String err = "Unsupported contentType: " + contentType + "use illegal codec: " + protocol.getClass().getName();
        logger.warn(err);
        throw new IOException(err);
    }

    @Override
    public void encodeResult(Result result, HttpServletRequest req, HttpServletResponse res) throws IOException {
        int ix;
        int i;
        String uri;
        Object obj;
        if (result.hasException()) {
            obj = result.getException();
            res.setHeader(HTTP_HEADER_EXCEPTION_TYPE, obj.getClass().getName());
        } else {
            obj = result.getValue();
        }
        String[] cts = DefaultHttpInvocationCodec.getContentTypeAndCharset(req);
        String ct = null;
        String str = req.getHeader("Accept");
        if (str != null && str.length() > 0) {
            String[] ss;
            for (String s : ss = str.split("[,;]")) {
                if (s.indexOf(61) != -1 || !TYPE_CODEC_MAP.containsKey(s)) continue;
                ct = s;
                break;
            }
        }
        if ((ct == null || ct.length() == 0) && (uri = req.getRequestURI()) != null && (i = uri.lastIndexOf(46)) > 0) {
            String suffix = uri.substring(i + 1);
            ct = DefaultHttpInvocationCodec.getContentTypeByCodec(suffix);
        }
        if (ct == null || ct.length() == 0) {
            ct = cts[0];
        }
        if (ct == null || ct.length() == 0) {
            ct = "text/json";
        }
        String cs = cts[1];
        str = req.getHeader("Accept-Charset");
        if (str != null && str.length() > 0 && (ix = str.indexOf(59)) > 0) {
            String[] tmp;
            for (String s : tmp = str.substring(0, ix).split("[,]")) {
                if (!this.acceptCharset(s)) continue;
                cs = s;
                break;
            }
        }
        res.setContentType(ct);
        res.setCharacterEncoding(cs);
        this.encodeResultData(ct, cs, obj, res);
    }

    protected void encodeResultData(String contentType, String charset, Object data, HttpServletResponse res) throws IOException {
        Codec<?, ?> protocol = this.acceptContentType(contentType);
        if (logger.isDebugEnabled()) {
            logger.debug("Http protocol codec flag: " + protocol + ", contentType: " + contentType);
        }
        if (protocol == null) {
            throw new IOException("Unsupported contentType: " + contentType);
        }
        if (protocol instanceof StreamCodec) {
            StreamCodec c = (StreamCodec)protocol;
            ServletOutputStream s = res.getOutputStream();
            c.encode((OutputStream)s, data);
            s.flush();
        } else if (protocol instanceof TextCodec) {
            TextCodec c = (TextCodec)protocol;
            PrintWriter w = res.getWriter();
            c.encode((Writer)w, data);
            ((Writer)w).flush();
        } else {
            String err = "Unsupported contentType: " + contentType + "use illegal codec: " + protocol.getClass().getName();
            logger.warn(err);
            throw new IOException(err);
        }
    }

    protected boolean acceptCharset(String cs) {
        return "utf-8".equalsIgnoreCase(cs) || "gbk".equalsIgnoreCase(cs) || "gb2312".equalsIgnoreCase(cs) || "iso8859-1".equalsIgnoreCase(cs);
    }

    protected Codec<?, ?> acceptContentType(String ct) {
        if (ct == null || ct.length() == 0) {
            return DEFAULT_CODEC;
        }
        return TYPE_CODEC_MAP.get(ct);
    }

    public static String getContentTypeByCodec(String name) {
        if (name == null || name.length() == 0) {
            return "text/json";
        }
        String contentType = CODEC_NAME_TYPE_MAP.get(name);
        if (contentType == null || contentType.length() == 0) {
            throw new IllegalArgumentException("Unsupported http codec " + name + ", only support \"json\", \"dubbo\", \"hessian2\", \"java\", \"compactedjava\"!");
        }
        return contentType;
    }

    public static Codec<?, ?> getCodec(String name) {
        return TYPE_CODEC_MAP.get(DefaultHttpInvocationCodec.getContentTypeByCodec(name));
    }

    static {
        Iterator<Class<Codec>> codecs = Service.providers(Codec.class);
        Class<Codec> clazz = null;
        while (codecs.hasNext()) {
            try {
                clazz = codecs.next();
                Codec codec = clazz.newInstance();
                CODEC_NAME_TYPE_MAP.put(codec.getName(), codec.getContentType());
                TYPE_CODEC_MAP.put(codec.getContentType(), codec);
            }
            catch (Throwable t) {
                logger.error("", "fail to codec class: " + clazz);
            }
        }
    }
}

