/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.http.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public final class Service {
    private static final String prefix = "META-INF/services/";

    private Service() {
    }

    private static void fail(Class<?> service, String msg, Throwable cause) {
        IllegalStateException sce = new IllegalStateException(service.getName() + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(Class<?> service, String msg) {
        throw new IllegalStateException(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) {
        Service.fail(service, u + ":" + line + ": " + msg);
    }

    private static int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names, Set<String> returned) throws IOException {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                Service.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                Service.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                Service.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!returned.contains(ln)) {
                names.add(ln);
                returned.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class<?> service, URL u, Set<String> returned) {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = Service.parseLine(service, u, r, lc, names, returned)) >= 0) {
            }
        }
        catch (IOException x) {
            Service.fail(service, ": " + x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                Service.fail(service, ": " + y);
            }
        }
        return names.iterator();
    }

    public static <T> Iterator<Class<? extends T>> providers(Class<T> service, ClassLoader loader) {
        return new LazyIterator(service, loader);
    }

    public static <T> Iterator<Class<? extends T>> providers(Class<T> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Service.providers(service, cl);
    }

    public static <T> Iterator<Class<? extends T>> installedProviders(Class<T> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return Service.providers(service, prev);
    }

    private static class LazyIterator<T>
    implements Iterator<Class<? extends T>> {
        Class<T> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;

        private LazyIterator(Class<T> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = Service.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    Service.fail(this.service, ": " + x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = Service.parse(this.service, this.configs.nextElement(), this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public Class<? extends T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                return Class.forName(cn, true, this.loader);
            }
            catch (ClassNotFoundException x) {
                Service.fail(this.service, "Provider " + cn + " not found");
            }
            catch (Exception x) {
                Service.fail(this.service, "Provider " + cn + " could not be instantiated: " + x, x);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

