/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.diamond.manager;

import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.manager.ManagerListenerAdapter;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.middleware.logger.Logger;
import java.io.IOException;
import java.util.List;

public class DiamondGovernanceServiceImpl
implements GovernanceService {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    public void getConfig(String dataId, final String uniqueName, String group, final GovernanceListener listener, String errorMsg) {
        try {
            String localConfigInfo = Diamond.getConfigFromSnapShot((String)dataId, (String)group);
            if (null != localConfigInfo && !localConfigInfo.isEmpty()) {
                listener.process(uniqueName, localConfigInfo);
            }
            Diamond.addListener((String)dataId, (String)group, (ManagerListener)new ManagerListenerAdapter(){

                public void receiveConfigInfo(String configInfo) {
                    listener.process(uniqueName, configInfo);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("", errorMsg, t);
        }
    }

    public void unRegister(ServiceMetadata metadata, String suffix) {
        String group = metadata.getGroup();
        String dataId = metadata.getUniqueName() + suffix;
        List listenerList = Diamond.getListeners((String)dataId, (String)group);
        if (listenerList != null) {
            for (ManagerListener listener : listenerList) {
                Diamond.removeListener((String)dataId, (String)group, (ManagerListener)listener);
            }
        }
    }

    public String getConfig(String dataId, String uniqueName, String group, long timeoutMs, String errorMsg) {
        try {
            return Diamond.getConfig((String)dataId, (String)group, (long)5000L);
        }
        catch (IOException e) {
            LOGGER.error("", errorMsg, (Throwable)e);
            return null;
        }
    }

    public void getConfigSync(String dataId, final String uniqueName, String group, final GovernanceListener listener, String errorMsg) {
        try {
            String rawConfig = Diamond.getConfig((String)dataId, (String)group, (long)5000L);
            if (null != rawConfig && !rawConfig.isEmpty()) {
                listener.process(uniqueName, rawConfig);
            }
            Diamond.addListener((String)dataId, (String)group, (ManagerListener)new ManagerListenerAdapter(){

                public void receiveConfigInfo(String configInfo) {
                    listener.process(uniqueName, configInfo);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("", errorMsg, t);
        }
    }
}

