/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.cloud;

import com.taobao.hsf.cloud.CloudRuleItem;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.AbstractRuleParser;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CloudRuleParser
extends AbstractRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    public String getRuleName() {
        return "HSF_SERVERS_ON_CLOUD";
    }

    public CloudRuleItem parse(String rawRule) throws RuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            Element root = doc.getDocumentElement();
            if (!"servers".equals(root.getNodeName())) {
                LOGGER.warn("[CloudRule Parser] Invalid rule: 'servers' node needed.");
                return null;
            }
            CloudRuleItem cloudRule = null;
            String localIp = InetAddressUtil.getIP();
            NodeList ruleList = root.getChildNodes();
            for (int h = 0; h < ruleList.getLength(); ++h) {
                Node nodeRule = ruleList.item(h);
                if (nodeRule.getNodeType() != 1) continue;
                if (!"server".equals(nodeRule.getNodeName())) {
                    LOGGER.warn("[CloudRule Parser] Invalid rule: unsupported node " + nodeRule + ".");
                    return null;
                }
                if (!localIp.equals(nodeRule.getAttributes().getNamedItem("ip").getNodeValue())) continue;
                NodeList nodeList = nodeRule.getChildNodes();
                String vip = null;
                List<String> csList = null;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    if ("vip".equals(node.getNodeName())) {
                        vip = node.getTextContent().trim();
                        continue;
                    }
                    if ("cs".equals(node.getNodeName())) {
                        csList = Arrays.asList(node.getTextContent().trim().split("\\|"));
                        continue;
                    }
                    LOGGER.warn("[CloudRule Parser] Unsupported node " + node + ".");
                }
                cloudRule = new CloudRuleItem(vip, csList);
            }
            return cloudRule;
        }
        catch (Exception e) {
            throw new RuleParseException("[CloudRule Parser]", "Cloud Rule parsed failed", (Throwable)e);
        }
    }
}

