/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.cloud;

import com.taobao.hsf.cloud.CloudRuleItem;
import com.taobao.hsf.cloud.CloudRuleParser;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookServiceAdapter;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class OnCloudComponent
extends ProcessHookServiceAdapter
implements GovernanceListener {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private final CloudRuleParser ruleParser = new CloudRuleParser();
    private final GovernanceService governanceService = (GovernanceService)HSFServiceContainer.getInstance(GovernanceService.class, (String)((ConfigurationService)HSFServiceContainer.getInstance(ConfigurationService.class)).getGovernanceType());

    public void prePublish(ServiceMetadata metadata) {
        this.retrieveRule(metadata);
    }

    private void registerRule(String rawRule) {
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.info("[Cloud Component] Empty Cloud rule received.");
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Cloud Component] Cloud rule received: [{0}]", rawRule));
        if ("@".equals(rawRule.trim())) {
            LOGGER_CONFIG.info("[Cloud Component]  CLEAR command Received.");
            for (ProviderServiceModel serviceModel : ApplicationModel.instance().allProvidedServices()) {
                this.checkCsListForRepublish(serviceModel.getMetadata());
            }
            return;
        }
        CloudRuleItem cloudRule = null;
        try {
            cloudRule = this.ruleParser.parse(rawRule);
        }
        catch (Throwable t) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"\u4e1a\u52a1\u95ee\u9898", (String)MessageFormat.format("[Cloud Component] Cloud rule [{0}] parsed failed: {1}", rawRule, t)));
            return;
        }
        if (cloudRule == null) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Cloud Component] Invalid Cloud rules received."));
            return;
        }
        if (!cloudRule.validate()) {
            LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Cloud Component] Invalid Cloud rules received."));
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Cloud Component] Cloud rule parsed OK: {0}", cloudRule));
        for (ProviderServiceModel serviceModel : ApplicationModel.instance().allProvidedServices()) {
            ServiceMetadata metadata = serviceModel.getMetadata();
            this.checkCsListForRepublish(cloudRule, metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCsListForRepublish(CloudRuleItem cloudRule, ServiceMetadata metadata) {
        List csList = cloudRule.getCsList();
        if (csList == null) {
            csList = metadata.getConfigserverCenter();
        }
        ServiceMetadata serviceMetadata = metadata;
        synchronized (serviceMetadata) {
            if (csList == null || ((Object)csList).equals(metadata.getConfigserverCenter())) {
                return;
            }
            metadata.fireMetadataBeforeChanged();
            metadata.setConfigserverCenter(csList);
            metadata.fireMetadataAfterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCsListForRepublish(ServiceMetadata metadata) {
        List csList = metadata.getConfigserverCenter();
        ServiceMetadata serviceMetadata = metadata;
        synchronized (serviceMetadata) {
            metadata.fireMetadataBeforeChanged();
            metadata.setConfigserverCenter(csList);
            metadata.fireMetadataAfterChanged();
        }
    }

    private void retrieveRule(ServiceMetadata metadata) {
        if (inited.compareAndSet(false, true)) {
            String appName = AppInfoUtils.getAppName();
            if (appName == null) {
                LOGGER_CONFIG.error("", "[Cloud Component] Can not subscribe cloud rule: appName is null.");
            } else {
                String dataId = appName + ".HSFCLOUDRULE";
                String group = "HSF";
                this.subscribeGroupingRule(dataId, "HSF");
            }
        }
    }

    private void subscribeGroupingRule(String dataId, String group) {
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, null, group, (GovernanceListener)this, LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0022", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Cloud Component] Process cloud rule failed"));
        }
    }

    public void process(String dataID, String configInfo) {
        this.registerRule(configInfo);
    }
}

