/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.grouping.service;

import com.taobao.hsf.grouping.service.GroupingRuleItem;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public final class GroupingRule
implements Rule {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String LOCAL_IP = InetAddressUtil.getIP();
    public static final String GROUTPING_RULE_PROVIDER_SUFFIX = ".GROUPINGRULE";
    public static final String NAME = "groupingRule";
    public static final String TAG_RULES = "rules";
    public static final String TAG_RULE = "rule";
    public static final String TAG_SERVICES = "services";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_IPS = "ips";
    public static final String TAG_IP = "ip";
    public static final String TAG_GROUP = "group";
    public static final String TAG_TYPE = "type";
    private List<GroupingRuleItem> rules = null;

    public void addRule(GroupingRuleItem ruleItem) {
        if (ruleItem == null) {
            return;
        }
        this.getRules().add(ruleItem);
    }

    public String getGroup(String serviceUniqueName, String type) {
        if (this.getRules().isEmpty()) {
            return null;
        }
        for (GroupingRuleItem rule : this.getRules()) {
            if (!rule.accept(serviceUniqueName, LOCAL_IP, type)) continue;
            String group = rule.getGroup();
            LOGGER.info(MessageFormat.format("[Grouping Component] Service [{0} - {1}] is grouped into [{2}]", LOCAL_IP, serviceUniqueName, group));
            return group;
        }
        return null;
    }

    public String getName() {
        return "GroupingRule";
    }

    public String getRawRule() {
        throw new UnsupportedOperationException();
    }

    public List<GroupingRuleItem> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<GroupingRuleItem>();
        }
        return this.rules;
    }

    public String toString() {
        return "GroupingRule [rules=" + this.rules + "]";
    }

    public boolean validate() {
        for (GroupingRuleItem rule : this.getRules()) {
            if (rule.validate()) continue;
            LOGGER.warn("[Grouping Component] Invalid grouping rule defined: " + rule);
            return false;
        }
        return true;
    }
}

