/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.grouping.service;

import com.taobao.hsf.grouping.service.GroupingRule;
import com.taobao.hsf.grouping.service.GroupingRuleItem;
import com.taobao.hsf.grouping.service.GroupingRuleParseException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.AbstractRuleParser;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GroupingRuleParser
extends AbstractRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    public String getRuleName() {
        return "groupingRule";
    }

    public GroupingRule parse(String uniqueName, String rawRule) throws GroupingRuleParseException {
        GroupingRule ret = this.parse(rawRule);
        String appName = AppInfoUtils.getAppName();
        if (null == appName || !appName.equals(uniqueName)) {
            for (GroupingRuleItem each : ret.getRules()) {
                each.getServices().clear();
                each.getServices().add(uniqueName);
            }
        }
        return ret;
    }

    public GroupingRule parse(String rawRule) throws GroupingRuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            Element root = doc.getDocumentElement();
            if (!"rules".equals(root.getNodeName())) {
                LOGGER.warn("[GroupingRule Parser] Invalid rule: 'rules' node needed.");
                return null;
            }
            GroupingRule groupingRule = new GroupingRule();
            NodeList ruleList = root.getChildNodes();
            for (int h = 0; h < ruleList.getLength(); ++h) {
                Node nodeRule = ruleList.item(h);
                if (nodeRule.getNodeType() != 1) continue;
                if (!"rule".equals(nodeRule.getNodeName())) {
                    LOGGER.warn("[GroupingRule Parser] Invalid rule: unsupported node " + nodeRule + ".");
                    return null;
                }
                GroupingRuleItem ruleItem = new GroupingRuleItem();
                NodeList nodeList = nodeRule.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String service;
                    Node child;
                    int j;
                    NodeList children;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    if ("services".equals(node.getNodeName())) {
                        children = node.getChildNodes();
                        for (j = 0; j < children.getLength(); ++j) {
                            child = children.item(j);
                            if (child.getNodeType() != 1 || !"service".equals(child.getNodeName())) continue;
                            service = child.getTextContent().trim();
                            ruleItem.getServices().add(service);
                        }
                        continue;
                    }
                    if ("ips".equals(node.getNodeName())) {
                        children = node.getChildNodes();
                        for (j = 0; j < children.getLength(); ++j) {
                            child = children.item(j);
                            if (child.getNodeType() != 1 || !"ip".equals(child.getNodeName())) continue;
                            service = child.getTextContent().trim();
                            ruleItem.getIps().add(service);
                        }
                        continue;
                    }
                    if ("group".equals(node.getNodeName())) {
                        String group = node.getTextContent().trim();
                        if (group == null || group.length() == 0) {
                            LOGGER.warn("[GroupingRule Parser] Invalid rule: 'group' node needed.");
                            return null;
                        }
                        ruleItem.setGroup(group);
                        continue;
                    }
                    if ("type".equals(node.getNodeName())) {
                        String type = node.getTextContent().trim();
                        if (StringUtils.isBlank((String)type)) {
                            LOGGER.warn("[GroupingRule Parser] Invalid rule: 'type' node cannot be empty.");
                            return null;
                        }
                        if (!type.equalsIgnoreCase("c")) {
                            LOGGER.warn("[GroupingRule Parser] Invalid rule: 'type' should be c.");
                            return null;
                        }
                        ruleItem.setType(type);
                        continue;
                    }
                    LOGGER.warn("[GroupingRule Parser] Unsupported node " + node + ".");
                    return null;
                }
                groupingRule.addRule(ruleItem);
            }
            return groupingRule;
        }
        catch (Exception e) {
            throw new GroupingRuleParseException("GroupingRule", "Grouping Rule parsed failed", e);
        }
    }
}

