/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.metadata.component;

import com.ali.unit.rule.Router;
import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.AddressSubscribeListener;
import com.taobao.hsf.address.MetadataAddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.event.Event;
import com.taobao.hsf.event.EventDispatcher;
import com.taobao.hsf.event.EventListener;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataInfoStoreService;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.flowcontrol.FlowControlRuleParseException;
import com.taobao.hsf.route.flowcontrol.FlowControlRuleParser;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.route.service.RouteRuleParser;
import com.taobao.hsf.route.service.RouteRuleParserException;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.HSFServiceTargetUtil;
import com.taobao.hsf.util.StringSplitter;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MetadataComponent
implements MetadataService,
EventListener,
GovernanceListener,
AddressSubscribeListener {
    private static Logger LOGGER = LoggerInit.LOGGER;
    private static Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private static final String RULES_SUFFIX = ".RULES";
    private final ConfigurationService configurationService = (ConfigurationService)HSFServiceContainer.getInstance(ConfigurationService.class);
    private final List<RouteRuleParser> routeRuleParsers = HSFServiceContainer.getInstances(RouteRuleParser.class);
    private final FlowControlRuleParser flowControlRuleParser = new FlowControlRuleParser();
    private final MetadataAddressService metadataAddressService = (MetadataAddressService)HSFServiceContainer.getInstance(MetadataAddressService.class, (String)this.configurationService.getRegistryType());
    private final AddressService addressService = (AddressService)HSFServiceContainer.getInstance(AddressService.class);
    private final UnitAddressService unitAddressService = (UnitAddressService)HSFServiceContainer.getInstance(UnitAddressService.class);
    private final GovernanceService governanceService = (GovernanceService)HSFServiceContainer.getInstance(GovernanceService.class, (String)this.configurationService.getGovernanceType());
    private final MetadataInfoStoreService metadataInfoStoreService = (MetadataInfoStoreService)HSFServiceContainer.getInstance(MetadataInfoStoreService.class, (String)this.configurationService.getDataStoreType());

    public MetadataComponent() {
        EventDispatcher.addEventListener((EventListener)this);
        if (this.unitAddressService != null) {
            this.unitAddressService.setMetadataService((MetadataService)this);
        }
    }

    public synchronized void publish(ServiceMetadata metadata) {
        String writeMode;
        if (Router.isUnitMode() && (writeMode = metadata.getWriteMode()) != null && writeMode.equals("center")) {
            if (!Router.isCenterUnit()) {
                LOGGER_CONFIG.info("\u63a5\u53e3[" + metadata.getInterfaceName() + "]\u7248\u672c[" + metadata.getVersion() + "]\u662f\u4e2d\u5fc3\u670d\u52a1\uff0c\u4f46\u662f\u672c\u673a\u4e0d\u5728\u4e2d\u5fc3\u5355\u5143\uff0c\u670d\u52a1\u672a\u53d1\u5e03\uff01");
                return;
            }
            if (metadata.getConfigStyle() == EnumConfigStyle.DUBBO) {
                metadata.removeProperty("WRITE_MODE");
                metadata.addProperty("DUBBO_WRITE_MODE", "center");
            }
        }
        try {
            this.metadataAddressService.publish(metadata);
        }
        catch (HSFException e) {
            LOGGER.error("", "publish failed", (Throwable)e);
        }
    }

    public boolean resubscribe(ServiceMetadata metadata) {
        if (metadata == null) {
            LOGGER.info("[Metadata Component] Service metadata can not be null.");
            return false;
        }
        this.metadataAddressService.unregisterConsumer(metadata);
        try {
            Thread.sleep(400L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.metadataAddressService.subscribe(metadata, (AddressSubscribeListener)this);
            LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] subscribe done.", metadata.getUniqueName()));
            return true;
        }
        catch (HSFException e) {
            LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] subscribe failed.", metadata.getUniqueName()), new Object[]{e});
            return false;
        }
    }

    public boolean republish(ServiceMetadata metadata) {
        if (metadata == null) {
            LOGGER.info("[Metadata Component] Service metadata can not be null.");
            return false;
        }
        this.unregister(metadata);
        this.publish(metadata);
        LOGGER.info(MessageFormat.format("[Metadata Component] Service [{0}] published done.", metadata.getUniqueName()));
        return true;
    }

    public void subscribe(ServiceMetadata metadata) {
        String dataId = metadata.getUniqueName() + RULES_SUFFIX;
        String group = metadata.getGroup();
        String serviceUniqueName = metadata.getUniqueName();
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, serviceUniqueName, group, (GovernanceListener)this, "[Metadata Component] Process rules failed");
        }
        try {
            this.metadataAddressService.subscribe(metadata, (AddressSubscribeListener)this);
        }
        catch (HSFException e) {
            LOGGER.error("", "subscribe failed", (Throwable)e);
        }
    }

    private void registerRule(String serviceUniqueName, String rawRule) {
        FlowControlRule flowControlRule;
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.warn(MessageFormat.format("[Metadata Component] Received empty rule for service [{0}].", serviceUniqueName));
            return;
        }
        LOGGER_CONFIG.warn(MessageFormat.format("[Metadata Component] Received rule for service [{0}]: {1}.", serviceUniqueName, rawRule));
        StringSplitter splitter = new StringSplitter(rawRule, new String[]{"flowControl@", "Groovy_v200907@"});
        if (splitter.has("Groovy_v200907@")) {
            String rawRoutingRule = splitter.get("Groovy_v200907@");
            RouteRule routingRule = this.parseRouteRule(serviceUniqueName, rawRoutingRule);
            if (routingRule != null) {
                this.addressService.setServiceRouteRule(serviceUniqueName, routingRule);
                if (this.unitAddressService != null) {
                    this.unitAddressService.setServiceRouteRule(serviceUniqueName, routingRule);
                }
            } else {
                LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0025", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("Could not parse route rule:" + rawRoutingRule)));
            }
        }
        if (splitter.has("flowControl@")) {
            String rawFlowControlRule = splitter.get("flowControl@");
            flowControlRule = this.parseFlowControlRule(rawFlowControlRule);
            if (flowControlRule != null) {
                this.addressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                if (this.unitAddressService != null) {
                    this.unitAddressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                }
            } else {
                LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0026", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("Could not parse flowcontrol rule:" + rawFlowControlRule)));
            }
        } else {
            Float threshold = this.configurationService.getFlowControlThreshold();
            if (null != threshold) {
                flowControlRule = new FlowControlRule();
                flowControlRule.setLocalPreferredSwitch("on");
                flowControlRule.setThreshold(threshold.floatValue());
                if (flowControlRule.validate()) {
                    this.addressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                    if (this.unitAddressService != null) {
                        this.unitAddressService.setFlowControlRule(serviceUniqueName, flowControlRule);
                    }
                } else {
                    LOGGER_CONFIG.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0026", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("flowcontrol rule validate false :" + flowControlRule.toString())));
                }
            }
        }
    }

    private RouteRule parseRouteRule(String serviceUniqueName, String rawRoutingRule) {
        Class<?> serviceInterface;
        try {
            String interfaceName = serviceUniqueName.substring(0, serviceUniqueName.indexOf(":"));
            serviceInterface = Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0024", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("[Address Component] Interface class not found: " + serviceUniqueName)), (Throwable)e);
            return null;
        }
        ArrayList<String> allMethodSigs = new ArrayList<String>();
        for (Method m : serviceInterface.getMethods()) {
            allMethodSigs.add(RouteRule.joinMethodSigs((Method)m));
        }
        RouteRule routingRule = null;
        for (RouteRuleParser parser : this.routeRuleParsers) {
            try {
                routingRule = parser.parse((Object)rawRoutingRule, allMethodSigs);
            }
            catch (RouteRuleParserException e) {
                LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0025", (String)"\u4e1a\u52a1\u95ee\u9898", (String)("[Address Component] Route rule parsed failed: " + rawRoutingRule)), (Throwable)e);
                return null;
            }
            if (routingRule == null) continue;
            break;
        }
        return routingRule;
    }

    private FlowControlRule parseFlowControlRule(String rawFlowControlRule) {
        FlowControlRule flowControlRule = null;
        if (this.flowControlRuleParser.accept(rawFlowControlRule)) {
            try {
                flowControlRule = this.flowControlRuleParser.parse(rawFlowControlRule);
                LOGGER_CONFIG.warn("[Address Pool] Flow control rule parsed OK: " + flowControlRule);
                if (!flowControlRule.validate()) {
                    return null;
                }
            }
            catch (FlowControlRuleParseException e) {
                LOGGER_CONFIG.error("", LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0026", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Address Pool] Flow control rule parsed failed."), (Throwable)e);
                return null;
            }
        }
        return flowControlRule;
    }

    public synchronized void unregister(ServiceMetadata metadata) {
        this.metadataAddressService.unregisterProvider(metadata);
    }

    public void processUnitConfig(ServiceMetadata metadata, List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            return;
        }
        for (String url : urls) {
            Properties props = HSFServiceTargetUtil.getTargetProperties((String)url);
            String writeMode = props.getProperty("WRITE_MODE");
            String route = props.getProperty("ROUTE");
            if (writeMode == null) continue;
            if (writeMode.equals("unit") && route != null) {
                try {
                    metadata.setRoute(Integer.parseInt(route));
                }
                catch (Exception e) {
                    LOGGER_CONFIG.warn("parse unit-route error", new Object[]{e});
                    continue;
                }
            }
            metadata.setWriteMode(writeMode);
            LOGGER_CONFIG.warn(MessageFormat.format("[Unit-Config]-HSF\u670d\u52a1{0}\u89e3\u6790\u540e\u5f97\u51fa\u7684writeMode\u4e3a{1}", metadata.getUniqueName(), writeMode));
            return;
        }
        metadata.setWriteMode(null);
    }

    public void onEvent(Event event) {
        switch (event.getEventType()) {
            case MetaDataChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (metadata.isProvider()) {
                    if (!metadata.isReadyToPublish()) {
                        LOGGER.info("\u63a5\u53e3[" + metadata.getInterfaceName() + "]\u7248\u672c[" + metadata.getVersion() + "]\u670d\u52a1\u4f7f\u7528\u4e86\u5ef6\u8fdf\u53d1\u5e03\u529f\u80fd\uff0c\u670d\u52a1\u5f52\u7ec4\u5df2\u4fee\u6539\uff0c\u4f46\u670d\u52a1\u672a\u53d1\u5e03\uff01");
                        return;
                    }
                    this.republish(metadata);
                } else {
                    this.subscribe(metadata);
                }
                metadata.recoverGroupFlag();
                this.metadataInfoStoreService.store(metadata);
                break;
            }
            case MetaDataBeforeChanged: {
                ServiceMetadata metadata = (ServiceMetadata)event.getSource();
                if (metadata.isProvider()) break;
                this.metadataAddressService.unregisterConsumer(metadata);
                if (this.governanceService == null) break;
                this.governanceService.unRegister(metadata, RULES_SUFFIX);
                break;
            }
        }
    }

    public void process(String uniqueName, String configInfo) {
        this.registerRule(uniqueName, configInfo);
    }

    public void processAddress(ServiceMetadata metadata, List<String> urls) {
        if (null != urls && !urls.isEmpty()) {
            String serviceUniqueName = metadata.getUniqueName();
            this.addressService.setServiceAddresses(serviceUniqueName, urls);
            this.processUnitConfig(metadata, urls);
            if (this.unitAddressService != null) {
                this.unitAddressService.setServiceAddresses(serviceUniqueName, urls);
            }
        }
    }
}

