/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.process.component;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.taobao.hsf.bytecode.JavassistProxy;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataInfoStoreService;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookService;
import com.taobao.hsf.process.service.ProcessService;
import com.taobao.hsf.remoting.adaptor.dubbo.ExtendRpcInvocation;
import com.taobao.hsf.remoting.service.EchoService;
import com.taobao.hsf.remoting.service.GenericService;
import com.taobao.hsf.remoting.service.RPCProtocolTemplateService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class ProcessComponent
implements ProcessService {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final List<ProcessHookService> hookServices = HSFServiceContainer.getInstances(ProcessHookService.class);
    private final RPCProtocolTemplateService rpcProtocolService = (RPCProtocolTemplateService)HSFServiceContainer.getInstance(RPCProtocolTemplateService.class);
    private final MetadataService metadataService = (MetadataService)HSFServiceContainer.getInstance(MetadataService.class);
    private final ConfigurationService configurationService = (ConfigurationService)HSFServiceContainer.getInstance(ConfigurationService.class);
    private final MetadataInfoStoreService metadataInfoStoreService = (MetadataInfoStoreService)HSFServiceContainer.getInstance(MetadataInfoStoreService.class, (String)this.configurationService.getDataStoreType());

    public Object consume(ServiceMetadata metadata) throws HSFException {
        if (ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName()) != null) {
            return ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName()).getProxyObject();
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.preConsume(metadata);
        }
        ArrayList<Class> interfaces = new ArrayList<Class>(3);
        if (metadata.getIfClazz() != null) {
            interfaces.add(metadata.getIfClazz());
        }
        if (metadata.isSupportEcho()) {
            interfaces.add(EchoService.class);
        }
        if (!GenericService.class.equals((Object)metadata.getIfClazz())) {
            interfaces.add(GenericService.class);
        }
        Class[] interfacesArray = new Class[interfaces.size()];
        interfaces.toArray(interfacesArray);
        HSFServiceProxy proxy = new HSFServiceProxy(metadata, interfacesArray, !"javassist".equalsIgnoreCase(metadata.getProxyStyle()));
        Object proxyObj = proxy.getInstance();
        this.metadataService.subscribe(metadata);
        for (ProcessHookService hookService : this.hookServices) {
            hookService.afterConsume(metadata);
        }
        this.metadataInfoStoreService.store(metadata);
        return proxyObj;
    }

    public void publish(ServiceMetadata metadata) throws HSFException {
        try {
            this.rpcProtocolService.registerProvider(metadata);
        }
        catch (HSFException e) {
            LOGGER.error("", "RPC\u534f\u8bae\uff1a\u65b9\u5f0f\u53d1\u5e03HSF\u670d\u52a1\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u670d\u52a1\uff1a" + metadata.getUniqueName() + "\u7684rpc\u5c5e\u6027\u7684\u914d\u7f6e\uff01");
            throw e;
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.prePublish(metadata);
        }
        if (metadata.isReadyToPublish()) {
            if (!metadata.getGroup().equalsIgnoreCase(metadata.getDefaultGroup())) {
                this.metadataService.unregister(metadata);
            }
            this.metadataService.publish(metadata);
            LOGGER.info("\u63a5\u53e3[" + metadata.getUniqueName() + "]\u7ec4\u522b[" + metadata.getGroup() + "]\u53d1\u5e03\u4e3aHSF\u670d\u52a1\u6210\u529f\uff01");
        } else {
            LOGGER.info("\u63a5\u53e3[" + metadata.getUniqueName() + "]\u7ec4\u522b[" + metadata.getGroup() + "]\u670d\u52a1\u4f7f\u7528\u4e86\u5ef6\u8fdf\u53d1\u5e03\u529f\u80fd\uff0c\u670d\u52a1\u672a\u53d1\u5e03\uff01");
        }
        for (ProcessHookService hookService : this.hookServices) {
            hookService.afterPublish(metadata);
        }
        this.metadataInfoStoreService.store(metadata);
    }

    public void shutdown() throws HSFException {
        this.rpcProtocolService.shutdownHSFServer();
    }

    public static class HSFServiceProxy
    implements InvocationHandler {
        private static final RPCProtocolTemplateService rpcProtocolService = (RPCProtocolTemplateService)HSFServiceContainer.getInstance(RPCProtocolTemplateService.class);
        private final ServiceMetadata serviceConsumerMetadata;
        private final ConsumerServiceModel serviceModel;
        private final Invoker<?> invokerChain;
        private final Object instance;
        private final Method equalsMethod;
        private final Method toStringMethod;
        private final Method hashCodeMethod;

        public HSFServiceProxy(final ServiceMetadata metadata, Class<?>[] classes, boolean isJava) {
            this.serviceConsumerMetadata = metadata;
            Method equalsMethod1 = null;
            Method toStringMethod1 = null;
            Method hashCodeMethod1 = null;
            if (isJava) {
                this.instance = Proxy.newProxyInstance(this.serviceConsumerMetadata.getIfClazz().getClassLoader(), classes, (InvocationHandler)this);
                try {
                    Field hashCodeFeild = this.instance.getClass().getDeclaredField("m0");
                    hashCodeFeild.setAccessible(true);
                    hashCodeMethod1 = (Method)hashCodeFeild.get(this.instance);
                    Field equalsFeild = this.instance.getClass().getDeclaredField("m1");
                    equalsFeild.setAccessible(true);
                    equalsMethod1 = (Method)equalsFeild.get(this.instance);
                    Field toStringFeild = this.instance.getClass().getDeclaredField("m2");
                    toStringFeild.setAccessible(true);
                    toStringMethod1 = (Method)toStringFeild.get(this.instance);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), new Object[]{e});
                }
            } else {
                this.instance = JavassistProxy.getProxy((Class[])classes).newInstance((InvocationHandler)this);
            }
            ApplicationModel.instance().initConsumerService(metadata.getUniqueName(), new ConsumerServiceModel(metadata, this.instance, isJava));
            this.serviceModel = ApplicationModel.instance().getConsumedServiceModel(metadata.getUniqueName());
            this.hashCodeMethod = hashCodeMethod1;
            this.toStringMethod = toStringMethod1;
            this.equalsMethod = equalsMethod1;
            if (StringUtils.isNotBlank((String)metadata.getFilter())) {
                LOGGER.info("[Filter Enable:]" + metadata + "###" + metadata.getFilter());
                Invoker trueRpcInvoke = new Invoker(){

                    public URL getUrl() {
                        return URL.valueOf((String)("127.0.0.1?reference.filter=" + metadata.getFilter()));
                    }

                    public boolean isAvailable() {
                        return true;
                    }

                    public void destroy() {
                    }

                    public Class<?> getInterface() {
                        return HSFServiceProxy.this.serviceConsumerMetadata.getIfClazz();
                    }

                    public Result invoke(Invocation invocation) throws RpcException {
                        try {
                            RpcContext.getContext().getAttachments().putAll(invocation.getAttachments());
                            Object result = HSFServiceProxy.this.trueInvoke(HSFServiceProxy.this.serviceModel.getMethodModel(((ExtendRpcInvocation)invocation).getMethod()), invocation.getArguments());
                            return new RpcResult(result);
                        }
                        catch (Throwable e) {
                            return new RpcResult(e);
                        }
                    }
                };
                this.invokerChain = this.buildInvokerChain(trueRpcInvoke, "reference.filter", "ONLYTHEONE");
            } else {
                this.invokerChain = null;
            }
        }

        private <T> Invoker<T> buildInvokerChain(final Invoker<T> invoker, String key, String group) {
            Invoker last = invoker;
            List filters = ExtensionLoader.getExtensionLoader(Filter.class).getActivateExtension(invoker.getUrl(), key, group);
            LOGGER.info("[Filter Loaded:]###" + filters);
            if (filters.size() > 0) {
                for (int i = filters.size() - 1; i >= 0; --i) {
                    final Filter filter = (Filter)filters.get(i);
                    final Invoker next = last;
                    last = new Invoker<T>(){

                        public Class<T> getInterface() {
                            return invoker.getInterface();
                        }

                        public URL getUrl() {
                            return invoker.getUrl();
                        }

                        public boolean isAvailable() {
                            return invoker.isAvailable();
                        }

                        public Result invoke(Invocation invocation) throws RpcException {
                            return filter.invoke(next, invocation);
                        }

                        public void destroy() {
                            invoker.destroy();
                        }

                        public String toString() {
                            return invoker.toString();
                        }
                    };
                }
            }
            return last;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method == this.toStringMethod) {
                return this.serviceConsumerMetadata.getInterfaceName();
            }
            if (method == this.equalsMethod) {
                return proxy == args[0];
            }
            if (method == this.hashCodeMethod) {
                return System.identityHashCode(proxy);
            }
            if (this.invokerChain == null) {
                ConsumerMethodModel methodModel = this.serviceModel.getMethodModel(method);
                return this.trueInvoke(methodModel, args);
            }
            ExtendRpcInvocation invocation = new ExtendRpcInvocation(method, args);
            Result result = this.invokerChain.invoke((Invocation)invocation);
            if (result.hasException()) {
                throw result.getException();
            }
            return result.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object trueInvoke(ConsumerMethodModel methodModel, Object[] args) throws HSFException, Throwable {
            AtomicInteger maxPoolSize = this.serviceConsumerMetadata.getCurConsumerMaxPoolSize();
            if (maxPoolSize == null) {
                return rpcProtocolService.invokeWithMethodObject(methodModel, args);
            }
            int currentSize = maxPoolSize.decrementAndGet();
            try {
                if (currentSize < 0) {
                    String errorMsg = MessageFormat.format("\u6d88\u8d39\u7aef\u7ebf\u7a0b\u6c60\u5df2\u6ee1,service[{0}],consumerMaxPoolSize[{1}]", this.serviceConsumerMetadata.getUniqueName(), this.serviceConsumerMetadata.getConsumerMaxPoolSize());
                    LOGGER.warn(errorMsg);
                    throw new RuntimeException(new HSFException(errorMsg));
                }
                Object object = rpcProtocolService.invokeWithMethodObject(methodModel, args);
                return object;
            }
            finally {
                maxPoolSize.incrementAndGet();
            }
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

