/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.strategy.groovy;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.route.service.RouteRuleParser;
import com.taobao.hsf.route.service.RouteRuleParserException;
import com.taobao.hsf.route.strategy.groovy.Args2KeyClosure;
import com.taobao.middleware.logger.Logger;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyRouteRuleParser
implements RouteRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    public static final String PREFIX = "Groovy_v200907@";

    private static Method getMethod(Class<?> c, String name, Class<?> ... parameterTypes) throws RouteRuleParserException {
        try {
            return c.getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new RouteRuleParserException("\u83b7\u53d6\u65b9\u6cd5\u5931\u8d25\u3002\u65b9\u6cd5\u540d\uff1a" + name, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Object[] getMethodSigArgs(String m) {
        String[] methodSigs = m.split("#");
        String[] paramTypeNames = new String[methodSigs.length - 1];
        System.arraycopy(methodSigs, 1, paramTypeNames, 0, paramTypeNames.length);
        return new Object[]{methodSigs[0], paramTypeNames};
    }

    private static Object invoke(Object obj, Method m, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Throwable t) {
            LOGGER.warn("\u8c03\u7528\u65b9\u6cd5\uff1a" + m + "\u5931\u8d25", new Object[]{t});
            return null;
        }
    }

    public RouteRule parse(Object rawRouteRuleObj, List<String> methodSigs) throws RouteRuleParserException {
        Object interfaceRoutingRule;
        Object ruleObj;
        if (!(rawRouteRuleObj instanceof String)) {
            return null;
        }
        String groovyRule = (String)rawRouteRuleObj;
        if (!groovyRule.startsWith(PREFIX)) {
            return null;
        }
        if ((groovyRule = groovyRule.substring(PREFIX.length())).length() == 0) {
            return null;
        }
        GroovyClassLoader loader = new GroovyClassLoader(GroovyRouteRuleParser.class.getClassLoader());
        ClassLoader contextClassLoader = null;
        Class c_groovy = null;
        try {
            contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(null);
            }
            c_groovy = loader.parseClass(groovyRule);
        }
        catch (CompilationFailedException e) {
            throw new RouteRuleParserException("groovy \u7f16\u8bd1\u51fa\u9519!", (Throwable)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        if (c_groovy == null) {
            return new RouteRule();
        }
        try {
            ruleObj = c_groovy.newInstance();
        }
        catch (Throwable t) {
            throw new RouteRuleParserException("\u5b9e\u4f8b\u5316\u8def\u7531\u89c4\u5219\u5bf9\u8c61\u5931\u8d25", t);
        }
        RouteRule rule = new RouteRule();
        Method m_routingRuleMap = GroovyRouteRuleParser.getMethod(c_groovy, "routingRuleMap", new Class[0]);
        if (m_routingRuleMap == null) {
            LOGGER.warn("No routingRuleMap in groovy route rule");
            return rule;
        }
        Object keyedRules = GroovyRouteRuleParser.invoke(ruleObj, m_routingRuleMap, new Object[0]);
        if (keyedRules == null) {
            LOGGER.warn("No routingRuleMap in groovy route rule");
            return rule;
        }
        rule.setKeyedRules(this.cast2KeyedRules(keyedRules));
        Method m_interfaceRoutingRule = GroovyRouteRuleParser.getMethod(c_groovy, "interfaceRoutingRule", new Class[0]);
        if (m_interfaceRoutingRule != null && (interfaceRoutingRule = GroovyRouteRuleParser.invoke(ruleObj, m_interfaceRoutingRule, new Object[0])) != null) {
            rule.setInterfaceRule(interfaceRoutingRule);
        }
        Method m_mathodRoutingRule = GroovyRouteRuleParser.getMethod(c_groovy, "mathodRoutingRule", String.class, String[].class);
        Method m_argsRoutingRule = GroovyRouteRuleParser.getMethod(c_groovy, "argsRoutingRule", String.class, String[].class);
        HashMap<String, Object> methodRule = new HashMap<String, Object>();
        HashMap<String, Args2KeyClosure> argsRule = new HashMap<String, Args2KeyClosure>();
        for (String m : methodSigs) {
            Closure closure;
            Object key4mathod;
            Object[] args = GroovyRouteRuleParser.getMethodSigArgs(m);
            if (m_mathodRoutingRule != null && (key4mathod = GroovyRouteRuleParser.invoke(ruleObj, m_mathodRoutingRule, args)) != null) {
                methodRule.put(m, key4mathod);
            }
            if (m_argsRoutingRule == null || (closure = (Closure)GroovyRouteRuleParser.invoke(ruleObj, m_argsRoutingRule, args)) == null) continue;
            argsRule.put(m, new Args2KeyClosure(closure));
        }
        rule.setMethodRule(methodRule);
        rule.setArgsRule(argsRule);
        Method m_isIpRegexOn = GroovyRouteRuleParser.getMethod(c_groovy, "isIpRegexOn", new Class[0]);
        Object isIpRegexOn = true;
        if (m_isIpRegexOn != null) {
            isIpRegexOn = GroovyRouteRuleParser.invoke(ruleObj, m_isIpRegexOn, new Object[0]);
            LOGGER.warn("isIpRegexOn : " + isIpRegexOn);
        }
        rule.setIpRegexOn(((Boolean)isIpRegexOn).booleanValue());
        Method m_Protect = GroovyRouteRuleParser.getMethod(c_groovy, "isEmptyProtection", new Class[0]);
        Object isEmptyProtection = true;
        if (m_Protect == null) {
            LOGGER.warn("No isEmptyProtection in groovy route rule");
        } else {
            isEmptyProtection = GroovyRouteRuleParser.invoke(ruleObj, m_Protect, new Object[0]);
        }
        rule.setEmptyProtection(((Boolean)isEmptyProtection).booleanValue());
        LOGGER.info("Parse route rule successed, RouteRule:" + rule);
        return rule;
    }

    private Map<? extends Object, ? extends List<String>> cast2KeyedRules(Object keyedRules) throws RouteRuleParserException {
        try {
            return (Map)keyedRules;
        }
        catch (ClassCastException e) {
            throw new RouteRuleParserException("Groovy\u811a\u672croutingRuleMap\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u4e0d\u662fMap<? extends Object, ? extends List<String>>", (Throwable)e);
        }
    }
}

