/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.component.parser;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.tps.model.threshold.ConsumerLevel;
import com.taobao.hsf.tps.model.threshold.MethodLevel;
import com.taobao.hsf.tps.model.threshold.ServiceLevel;
import com.taobao.hsf.tps.model.threshold.Threshold;
import com.taobao.hsf.tps.service.TPSRule;
import com.taobao.hsf.tps.service.TPSRuleParseException;
import com.taobao.hsf.tps.service.TPSRuleParser;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThresholdTPSRuleParser
extends TPSRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String TAG_SERVICE = "serviceLevel";
    private static final String TAG_METHOD = "methodLevel";
    private static final String TAG_CONSUMER = "consumerLevel";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_RATE = "rate";
    private static final String ATTR_PEAK = "peak";
    private static final String ATTR_TIMEWINDOW = "timeWindow";
    private static final String ATTR_WITHARGSIGS = "methodNameWithArgSigs";

    public String getRuleName() {
        return "threshold";
    }

    public TPSRule parse(String rawRule) throws TPSRuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            Threshold threshold = new Threshold();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType()) continue;
                if (TAG_SERVICE.equals(node.getNodeName())) {
                    try {
                        ServiceLevel sl = (ServiceLevel)this.parseNode(node, TAG_SERVICE);
                        threshold.addServiceLevel(sl);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new TPSRuleParseException("TpsRule", e);
                    }
                    catch (NullPointerException e) {
                        throw new TPSRuleParseException("TpsRule", e);
                    }
                }
                LOGGER.warn("[TPSRule Parser] Unsupported node: " + node);
                return null;
            }
            return threshold;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[TPSRule Parser] Rate, peak, timeWindow must be int value.", new Object[]{e});
            return null;
        }
        catch (Exception e) {
            throw new TPSRuleParseException("TpsRule", "TPS Rule parsed failed!", e);
        }
    }

    private Object parseNode(Node node, String tagName) {
        NamedNodeMap attributes = node.getAttributes();
        Node attrNode = attributes.getNamedItem(ATTR_NAME);
        if (attrNode == null) {
            throw new NullPointerException("[TPSRule Parser] Invalid rule: 'name' attribute needed.");
        }
        String name = attrNode.getNodeValue();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("[TPSRule Parser] Invalid rule: empty name value.");
        }
        attrNode = attributes.getNamedItem(ATTR_RATE);
        if (attrNode == null) {
            throw new NullPointerException("[TPSRule Parser] Invalid rule: 'rate' attribute needed.");
        }
        int rate = Integer.valueOf(attrNode.getNodeValue());
        if (rate <= 0) {
            throw new IllegalArgumentException("[TPSRule Parser] Invalid rule: positive rate value needed.");
        }
        attrNode = attributes.getNamedItem(ATTR_TIMEWINDOW);
        int timeWindow = 0;
        if (attrNode != null && (timeWindow = Integer.valueOf(attrNode.getNodeValue()).intValue()) <= 0) {
            throw new IllegalArgumentException("[TPSRule Parser] Invalid rule: positive timeWindow value needed.");
        }
        attrNode = attributes.getNamedItem(ATTR_PEAK);
        int peak = 0;
        if (attrNode != null && (peak = Integer.valueOf(attrNode.getNodeValue()).intValue()) <= 0) {
            throw new IllegalArgumentException("[TPSRule Parser] Invalid rule: positive peak value needed.");
        }
        if (TAG_CONSUMER.equals(tagName)) {
            ConsumerLevel cl = new ConsumerLevel(name, rate, peak, timeWindow);
            return cl;
        }
        if (TAG_METHOD.equals(tagName)) {
            MethodLevel ml = new MethodLevel(name, rate, peak, timeWindow);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (1 != childNode.getNodeType() || !TAG_CONSUMER.equals(childNode.getNodeName())) continue;
                ConsumerLevel cl = (ConsumerLevel)this.parseNode(childNode, TAG_CONSUMER);
                ml.addConsumerLevel(cl);
            }
            return ml;
        }
        if (TAG_SERVICE.equals(tagName)) {
            ServiceLevel sl = new ServiceLevel(name, rate, peak, timeWindow);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (1 != childNode.getNodeType()) continue;
                if (TAG_METHOD.equals(childNode.getNodeName())) {
                    MethodLevel ml = (MethodLevel)this.parseNode(childNode, TAG_METHOD);
                    sl.addMethodLevel(ml);
                    continue;
                }
                if (!TAG_CONSUMER.equals(childNode.getNodeName())) continue;
                ConsumerLevel cl = (ConsumerLevel)this.parseNode(childNode, TAG_CONSUMER);
                sl.addConsumerLevel(cl);
            }
            attrNode = attributes.getNamedItem(ATTR_WITHARGSIGS);
            if (attrNode != null) {
                String value = attrNode.getNodeValue();
                if ("true".endsWith(value)) {
                    sl.setMethodNameWithArgSigs(true);
                } else if ("false".equals(value)) {
                    sl.setMethodNameWithArgSigs(false);
                } else {
                    throw new IllegalArgumentException("[TPSRule Parser] Unknown value for methodNameWithArgSigs attribution.");
                }
            }
            return sl;
        }
        throw new IllegalArgumentException("[TPSRule Parser] Unknown node name: " + tagName);
    }
}

