/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.component.parser;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.tps.model.whitelist.MethodLevel;
import com.taobao.hsf.tps.model.whitelist.ServiceLevel;
import com.taobao.hsf.tps.model.whitelist.WhiteList;
import com.taobao.hsf.tps.service.TPSRule;
import com.taobao.hsf.tps.service.TPSRuleParseException;
import com.taobao.hsf.tps.service.TPSRuleParser;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WhiteListTPSRuleParser
extends TPSRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String TAG_APP_NAME = "appName";
    private static final String TAG_SERVICE = "serviceLevel";
    private static final String TAG_METHOD = "methodLevel";
    private static final String TAG_CONSUMER = "appName";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_WITHARGSIGS = "methodNameWithArgSigs";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_ENCODER = "encoder";

    public String getRuleName() {
        return "whiteList";
    }

    public TPSRule parse(String rawRule) throws TPSRuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            WhiteList whiteList = new WhiteList();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType()) continue;
                if ("appName".equals(node.getNodeName())) {
                    String appName = node.getTextContent().trim();
                    if (appName == null || appName.length() == 0) {
                        LOGGER.warn("[TPSRule Parser] Invalid rule: empty application name in node: " + node);
                        continue;
                    }
                    whiteList.addConsumer(appName);
                    continue;
                }
                if (TAG_SERVICE.equals(node.getNodeName())) {
                    try {
                        ServiceLevel sl = (ServiceLevel)this.parseNode(node, TAG_SERVICE);
                        whiteList.addServiceLevel(sl);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new TPSRuleParseException("FlowControlRule", "TPS Rule parsed failed!", e);
                    }
                    catch (NullPointerException e) {
                        throw new TPSRuleParseException("FlowControlRule", "TPS Rule parsed failed!", e);
                    }
                }
                LOGGER.warn("[TPSRule Parser] Unsupported node: " + node);
                return null;
            }
            return whiteList;
        }
        catch (Exception e) {
            throw new TPSRuleParseException("FlowControlRule", "TPS Rule parsed failed!", e);
        }
    }

    private Object parseNode(Node node, String tagName) {
        if ("appName".equals(tagName)) {
            return node.getTextContent().trim();
        }
        NamedNodeMap attributes = node.getAttributes();
        Node attrNode = attributes.getNamedItem(ATTR_NAME);
        if (attrNode == null) {
            throw new NullPointerException("[TPSRule Parser] Invalid rule: 'name' attribute needed.");
        }
        String name = attrNode.getNodeValue();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("[TPSRule Parser] Invalid rule: empty name value.");
        }
        if (TAG_METHOD.equals(tagName)) {
            MethodLevel ml = new MethodLevel(name);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (1 != childNode.getNodeType() || !"appName".equals(childNode.getNodeName())) continue;
                String appName = (String)this.parseNode(childNode, "appName");
                if (appName == null || appName.length() == 0) {
                    LOGGER.warn("[TPSRule Parser] Invalid rule: empty application name in node: " + node);
                    continue;
                }
                ml.addConsumer(appName);
            }
            return ml;
        }
        if (TAG_SERVICE.equals(tagName)) {
            ServiceLevel sl = new ServiceLevel(name);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String value;
                Node encoderNode;
                String value2;
                Node childNode = nodeList.item(i);
                if (1 != childNode.getNodeType()) continue;
                if (TAG_METHOD.endsWith(childNode.getNodeName())) {
                    MethodLevel ml = (MethodLevel)this.parseNode(childNode, TAG_METHOD);
                    sl.addMethodLevel(ml);
                    continue;
                }
                if (!"appName".equals(childNode.getNodeName())) continue;
                NamedNodeMap appAttributes = childNode.getAttributes();
                String appName = (String)this.parseNode(childNode, "appName");
                if (appName == null || appName.length() == 0) {
                    LOGGER.warn("[TPSRule Parser] Invalid rule: empty application name in node: " + node);
                    continue;
                }
                sl.addConsumer(appName);
                Node keyNode = appAttributes.getNamedItem(ATTR_KEY);
                if (keyNode != null && (value2 = keyNode.getNodeValue()) != null && value2.length() > 0) {
                    sl.addKey(appName, value2);
                }
                if ((encoderNode = appAttributes.getNamedItem(ATTR_ENCODER)) == null || (value = encoderNode.getNodeValue()) == null || value.length() <= 0) continue;
                sl.addEncoder(appName, value);
            }
            attrNode = attributes.getNamedItem(ATTR_WITHARGSIGS);
            if (attrNode != null) {
                String value = attrNode.getNodeValue();
                if ("true".endsWith(value)) {
                    sl.setMethodNameWithArgSigs(true);
                } else if ("false".equals(value)) {
                    sl.setMethodNameWithArgSigs(false);
                } else {
                    throw new IllegalArgumentException("[TPSRule Parser] Unknown value for methodNameWithArgSigs attribution.");
                }
            }
            return sl;
        }
        throw new IllegalArgumentException("[TPSRule Parser] Unknown node name: " + tagName);
    }
}

