/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model;

import com.taobao.hsf.domain.HSFRequest;

public class StatNode {
    private String key;
    private long amount;

    public static String getRequestSignature(HSFRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append(request.getTargetServiceUniqueName()).append("_").append(request.getMethodName());
        for (String s : request.getMethodArgSigs()) {
            if (s != null) {
                sb.append("_").append(s.toLowerCase());
                continue;
            }
            sb.append("_null");
        }
        return sb.toString();
    }

    public StatNode(HSFRequest request) {
        this.key = StatNode.getRequestSignature(request);
        this.amount = 1L;
    }

    public boolean belongsTo(String serviceUniqueName) {
        if (serviceUniqueName == null || serviceUniqueName.length() == 0) {
            return false;
        }
        return this.key.startsWith(serviceUniqueName);
    }

    public long getAmount() {
        return this.amount;
    }

    public String getKey() {
        return this.key;
    }

    public boolean incrementIfMatches(HSFRequest request) {
        if (this.matches(request)) {
            ++this.amount;
            return true;
        }
        return false;
    }

    public boolean matches(HSFRequest request) {
        return this.key.equals(StatNode.getRequestSignature(request));
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

