/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.threshold;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.tps.model.threshold.BaseLevel;
import com.taobao.hsf.tps.model.threshold.ConsumerLevel;
import com.taobao.hsf.tps.model.threshold.MethodLevel;
import java.util.HashMap;
import java.util.Map;

public class ServiceLevel
extends BaseLevel {
    private boolean methodNameWithArgSigs = false;
    private Map<String, MethodLevel> methods;
    private Map<String, ConsumerLevel> consumers;

    public ServiceLevel(String name, int rate, int peak, int timeWindow) {
        super(name, rate, peak, timeWindow);
    }

    public void addConsumerLevel(ConsumerLevel cl) {
        this.getConsumers().put(cl.getName(), cl);
    }

    public void addMethodLevel(MethodLevel ml) {
        this.getMethods().put(ml.getName(), ml);
    }

    public Map<String, ConsumerLevel> getConsumers() {
        if (this.consumers == null) {
            this.consumers = new HashMap<String, ConsumerLevel>();
        }
        return this.consumers;
    }

    public Map<String, MethodLevel> getMethods() {
        if (this.methods == null) {
            this.methods = new HashMap<String, MethodLevel>();
        }
        return this.methods;
    }

    public boolean isMethodNameWithArgSigs() {
        return this.methodNameWithArgSigs;
    }

    public boolean matches(HSFRequest request) {
        MethodLevel ml;
        String[] argSigs;
        StringBuilder sb = new StringBuilder();
        sb.append(request.getMethodName());
        if (this.isMethodNameWithArgSigs() && (argSigs = request.getMethodArgSigs()) != null) {
            for (String argSig : argSigs) {
                if (argSig == null || argSig.isEmpty()) continue;
                sb.append("_").append(argSig);
            }
        }
        String methodKey = sb.toString();
        if (this.getMethods().containsKey(methodKey) && (ml = this.getMethods().get(methodKey)) != null) {
            return ml.matches(request);
        }
        if (this.getConsumers() != null && !this.getConsumers().isEmpty()) {
            ConsumerLevel cl;
            String consumer = null;
            if (request.getRequestProp("Consumer-AppName") != null) {
                consumer = (String)request.getRequestProp("Consumer-AppName");
            }
            if (consumer == null) {
                return this.check();
            }
            if (this.getConsumers().containsKey(consumer) && (cl = this.getConsumers().get(consumer)) != null) {
                return cl.check();
            }
        }
        return this.check();
    }

    public void setMethodNameWithArgSigs(boolean methodNameWithArgSigs) {
        this.methodNameWithArgSigs = methodNameWithArgSigs;
    }

    @Override
    public String toString() {
        return "ServiceLevel [name=" + this.name + ", limiter=" + this.limiter + ", consumers=" + this.consumers + ", methods=" + this.methods + ", methodNameWithArgSigs=" + this.methodNameWithArgSigs + "]";
    }

    @Override
    public boolean validate() {
        for (MethodLevel ml : this.getMethods().values()) {
            if (ml.validate()) continue;
            return false;
        }
        for (ConsumerLevel cl : this.getConsumers().values()) {
            if (cl.validate()) continue;
            return false;
        }
        return super.validate();
    }
}

