/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.weighting.component;

import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.event.Event;
import com.taobao.hsf.event.EventDispatcher;
import com.taobao.hsf.event.EventListener;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookServiceAdapter;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.weighting.WeightingRule;
import com.taobao.hsf.weighting.parser.WeightingRuleParser;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.text.MessageFormat;

public class WeightingComponent
extends ProcessHookServiceAdapter
implements EventListener,
GovernanceListener {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    public static final String WEIGHTRULE_SUFFIX = "WEIGHTINGRULE";
    private final AddressService addressService = (AddressService)HSFServiceContainer.getInstance(AddressService.class);
    private final UnitAddressService unitAddressService = (UnitAddressService)HSFServiceContainer.getInstance(UnitAddressService.class);
    private final GovernanceService governanceService = (GovernanceService)HSFServiceContainer.getInstance(GovernanceService.class, (String)((ConfigurationService)HSFServiceContainer.getInstance(ConfigurationService.class)).getGovernanceType());
    private final WeightingRuleParser ruleParser = new WeightingRuleParser();

    public WeightingComponent() {
        EventDispatcher.addEventListener((EventListener)this);
    }

    public void preConsume(ServiceMetadata metadata) {
        this.retrieveRule(metadata);
    }

    private WeightingRule registerRule(String uniqueName, String rawRule) {
        if (rawRule == null || rawRule.length() == 0) {
            LOGGER_CONFIG.info("[Weighting Component] Empty Grouping rule received.");
            return null;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Weighting Component] Grouping rule received: [{0}]", rawRule));
        if ("@".equals(rawRule.trim())) {
            LOGGER_CONFIG.info("[Weighting Component]  CLEAR command Received.");
            return null;
        }
        WeightingRule weightingRule = null;
        try {
            weightingRule = (WeightingRule)this.ruleParser.parse(rawRule);
        }
        catch (Throwable t) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0023", (String)"\u4e1a\u52a1\u95ee\u9898", (String)MessageFormat.format("[Weighting Component] Grouping rule [{0}] parsed failed: {1}", rawRule, t)));
            return null;
        }
        if (weightingRule == null) {
            LOGGER_CONFIG.info(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0023", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Weighting Component] Invalid grouping rules received."));
            return null;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Weighting Component] Grouping rule parsed OK: {0}", weightingRule));
        this.addressService.setWeightRule(uniqueName, weightingRule);
        if (this.unitAddressService != null) {
            this.unitAddressService.setWeightRule(uniqueName, weightingRule);
        }
        return weightingRule;
    }

    private WeightingRule retrieveRule(ServiceMetadata metadata) {
        String uniqueName = metadata.getUniqueName();
        String dataId = uniqueName + WEIGHTRULE_SUFFIX;
        String group = metadata.getGroup();
        if (this.governanceService != null) {
            this.governanceService.getConfig(dataId, uniqueName, group, (GovernanceListener)this, LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0023", (String)"\u4e1a\u52a1\u95ee\u9898", (String)"[Weighting Component] Process grouping rule failed, grouping rule [{0}], {1} "));
        }
        return null;
    }

    public void onEvent(Event event) {
        this.preConsume((ServiceMetadata)event.getSource());
    }

    public void process(String uniqueName, String configInfo) {
        this.registerRule(uniqueName, configInfo);
    }
}

