/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.weighting.parser;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.AbstractRuleParser;
import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.hsf.weighting.WeightingRule;
import com.taobao.hsf.weighting.WeightingRuleItem;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WeightingRuleParser
extends AbstractRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String RULE_NAME = "weightingRule";
    private static final String ROOT = "rules";
    private static final String RULE = "rule";
    private static final String IPS = "ips";
    private static final String IP = "ip";
    private static final String WEIGHT = "weight";
    private static final String EXPIRE_TIME = "expireTime";

    public String getRuleName() {
        return RULE_NAME;
    }

    public Rule parse(String rawRule) throws RuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            Element root = doc.getDocumentElement();
            if (!ROOT.equals(root.getNodeName())) {
                LOGGER.warn("[WeightingRule Parser] Invalid rule: 'rules' node needed.");
                return null;
            }
            WeightingRule weightRule = new WeightingRule(rawRule);
            NodeList ruleList = root.getChildNodes();
            for (int h = 0; h < ruleList.getLength(); ++h) {
                Node nodeRule = ruleList.item(h);
                if (nodeRule.getNodeType() != 1) continue;
                WeightingRuleItem ruleItem = new WeightingRuleItem();
                if (RULE.equals(nodeRule.getNodeName())) {
                    NodeList nodeList = nodeRule.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1) continue;
                        if (IPS.equals(node.getNodeName())) {
                            NodeList children = node.getChildNodes();
                            for (int j = 0; j < children.getLength(); ++j) {
                                Node child = children.item(j);
                                if (child.getNodeType() != 1 || !IP.equals(child.getNodeName())) continue;
                                String ip = child.getTextContent().trim();
                                ruleItem.addIpPattern(ip);
                            }
                            continue;
                        }
                        if (WEIGHT.equals(node.getNodeName())) {
                            String weight = node.getTextContent().trim();
                            if (!StringUtils.isNumeric((String)weight)) {
                                LOGGER.warn("[WeightingRule Parser] Invalid rule: 'weight' must be integer.");
                                return null;
                            }
                            int weightValue = Integer.parseInt(weight);
                            if (weightValue < 1) {
                                LOGGER.warn("[WeightingRule Parser] Invalid rule: 'weight' must be bigger 1.");
                                return null;
                            }
                            ruleItem.setWeight(weightValue);
                            continue;
                        }
                        LOGGER.warn("[WeightingRule Parser] Unsupported node " + node + ".");
                        return null;
                    }
                    weightRule.addItem(ruleItem);
                    continue;
                }
                if (EXPIRE_TIME.equals(nodeRule.getNodeName())) {
                    String expireTime = nodeRule.getTextContent().trim();
                    try {
                        SimpleDateFormat dataFormattor = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        weightRule.setExpireTime(dataFormattor.parse(expireTime).getTime());
                        continue;
                    }
                    catch (Throwable e) {
                        LOGGER.warn("[WeightingRule Parser] Invalid rule: 'expireTime' must be like yyyy-MM-dd HH:mm:ss.");
                        return null;
                    }
                }
                LOGGER.warn("[WeightingRule Parser] Invalid rule: unsupported node " + nodeRule + ".");
                return null;
            }
            return weightRule;
        }
        catch (Exception e) {
            throw new RuleParseException("Weighting Rule parsed failed", (Throwable)e);
        }
    }
}

