/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.Message;
import com.taobao.notify.message.MessageConverter;

public class ObjectMessage
extends Message {
    static final long serialVersionUID = -78961533445L;
    private Object object;

    public ObjectMessage() {
    }

    public ObjectMessage(byte[] msgId) {
        this.setMessageId(msgId);
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.ObjectMessage);
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        this.object = object;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectMessage other = (ObjectMessage)obj;
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Message innerToProcessType() {
        return this;
    }

    @Override
    public Message innerToSendType(MessageProperties properties) {
        return MessageConverter.toBytesMessage(this);
    }
}

