/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.Message;
import com.taobao.notify.message.MessageConverter;

public class StringMessage
extends Message {
    private static final long serialVersionUID = 4184758718796140785L;
    private String body = "";

    public StringMessage() {
        this.setConcreteType(Message.MessageClassType.StringMessage);
        this.setOriginType(Message.MessageClassType.StringMessage);
    }

    public StringMessage(byte[] msgId) {
        this.setMessageId(msgId);
        this.setConcreteType(Message.MessageClassType.StringMessage);
        this.setOriginType(Message.MessageClassType.StringMessage);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public Message innerToProcessType() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringMessage other = (StringMessage)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Message innerToSendType(MessageProperties properties) {
        StringMessage stringMsgResult = this;
        if (stringMsgResult.getBody().length() <= properties.getMaxStringMessageSize()) {
            return stringMsgResult;
        }
        return MessageConverter.toBytesMessage(stringMsgResult);
    }

    public String toString() {
        return super.toStringWithoutBody() + "\tContent :" + this.getBody() + "\n";
    }

    public String toExtString() {
        return super.toExtStringWithoutBody() + "\tContent :" + this.getBody() + "\n";
    }

    public String toFullString() {
        return super.toFullStringWithoutBody() + "\tContent :" + this.getBody() + "\n";
    }
}

