/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.subscription;

import com.googlecode.aviator.Expression;
import com.taobao.notify.message.Message;
import com.taobao.notify.subscription.BindingConstants;
import com.taobao.notify.subscription.ExchangeType;
import com.taobao.notify.subscription.eval.MessageMatcher;
import com.taobao.notify.subscription.eval.MessagePropertiesParser;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Binding
implements Serializable,
Comparable<Binding> {
    static final long serialVersionUID = -73981177754390L;
    private ExchangeType exchangeType;
    private String key;
    private String group;
    private boolean persistence;
    private String topic;
    private int waterMark = -1;
    public static final int DEFAULT_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    private int priority = 5;
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    static Pattern pattern = Pattern.compile("([a-zA-Z]+)=`(.*?)`");

    public Binding duplicate() {
        return new Binding(this.exchangeType, this.topic, this.key, this.group, this.waterMark, this.persistence, this.priority);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.exchangeType).append((Object)this.topic).append((Object)this.group).append((Object)this.key).append(this.priority).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Binding)) {
            return false;
        }
        Binding rhs = (Binding)obj;
        return new EqualsBuilder().append((Object)this.exchangeType, (Object)rhs.exchangeType).append((Object)this.topic, (Object)rhs.topic).append((Object)this.group, (Object)rhs.group).append((Object)this.key, (Object)rhs.key).append(this.priority, rhs.priority).isEquals();
    }

    public boolean match(Message message) {
        if (!this.topic.equals(message.getTopic())) {
            return false;
        }
        if (this.group != null && !this.group.equals(message.getTargetGroup())) {
            return false;
        }
        switch (this.exchangeType) {
            case DIRECT: {
                return this.key.equals(message.getMessageType());
            }
            case FANOUT: {
                return true;
            }
            case HEADER: {
                Expression exp = (Expression)this.getAttribute(BindingConstants.GROOVY_OBJECT_ATTR);
                if (exp == null) {
                    exp = MessageMatcher.getCompiledExpression(this.key);
                    this.setAttribute(BindingConstants.GROOVY_OBJECT_ATTR, exp);
                }
                return MessageMatcher.match(MessagePropertiesParser.getMessageProperties(message), exp);
            }
            case PATTERN: {
                Pattern pattern = (Pattern)this.getAttribute(BindingConstants.PATTERN_ATTR);
                if (pattern == null) {
                    pattern = Pattern.compile(this.key);
                    this.setAttribute(BindingConstants.PATTERN_ATTR, pattern);
                }
                return pattern.matcher(message.getMessageType()).matches();
            }
        }
        return false;
    }

    private Binding(ExchangeType exchangeType, String topic, String key, String group, int waterMark, boolean persistence, int priority) {
        this.topic = topic;
        this.exchangeType = exchangeType;
        this.key = key;
        this.persistence = persistence;
        this.group = group;
        this.waterMark = waterMark;
        this.priority = priority;
    }

    private Binding(ExchangeType exchangeType, String topic, String key, String group, int waterMark, boolean persistence) {
        this(exchangeType, topic, key, group, waterMark, persistence, 5);
    }

    public void setPriority(int priority) {
        this.priority = Binding.checkAndModifyPriority(priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(int waterMark) {
        this.waterMark = waterMark;
    }

    public String getGroup() {
        return this.group;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(ExchangeType exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    private static int checkAndModifyPriority(int priority) {
        if (priority > 10) {
            return 10;
        }
        if (priority < 1) {
            return 1;
        }
        return priority;
    }

    public static Binding direct(String topic, String messageType, String group, int waterMark, boolean persistence) {
        return Binding.direct(topic, messageType, group, waterMark, persistence, 5);
    }

    public static Binding direct(String topic, String messageType, String group, int waterMark, boolean persistence, int priority) {
        if (topic == null) {
            throw new IllegalArgumentException("Null topic");
        }
        if (messageType == null) {
            throw new IllegalArgumentException("Null messageType");
        }
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        return new Binding(ExchangeType.DIRECT, topic, messageType, group, waterMark, persistence, Binding.checkAndModifyPriority(priority));
    }

    public static Binding fanout(String topic, String group, int waterMark, boolean persistence) {
        return Binding.fanout(topic, group, waterMark, persistence, 5);
    }

    public static Binding fanout(String topic, String group, int waterMark, boolean persistence, int priority) {
        if (topic == null) {
            throw new IllegalArgumentException("Null topic");
        }
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        return new Binding(ExchangeType.FANOUT, topic, "fanout", group, waterMark, persistence, Binding.checkAndModifyPriority(priority));
    }

    public static Binding pattern(String topic, String pattern, String group, int waterMark, boolean persistence) {
        return Binding.pattern(topic, pattern, group, waterMark, persistence, 5);
    }

    public static Binding pattern(String topic, String pattern, String group, int waterMark, boolean persistence, int priority) {
        if (topic == null) {
            throw new IllegalArgumentException("Null topic");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        Pattern.compile(pattern);
        return new Binding(ExchangeType.PATTERN, topic, pattern, group, waterMark, persistence, Binding.checkAndModifyPriority(priority));
    }

    public static Binding header(String topic, String expression, String group, int waterMark, boolean persistence) {
        return Binding.header(topic, expression, group, waterMark, persistence, 5);
    }

    public static Binding header(String topic, String expression, String group, int waterMark, boolean persistence, int priority) {
        if (topic == null) {
            throw new IllegalArgumentException("Null topic");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Null expression");
        }
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        try {
            MessageMatcher.verify(expression);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return new Binding(ExchangeType.HEADER, topic, expression, group, waterMark, persistence, Binding.checkAndModifyPriority(priority));
    }

    public static Binding valueOf(String str) {
        if (!str.startsWith("[Binding ")) {
            return null;
        }
        Matcher matcher = pattern.matcher(str);
        String topic = "";
        String group = "";
        String key = "";
        int waterMark = -1;
        boolean persistence = false;
        ExchangeType exchangeType = null;
        int priority = 5;
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (name.equals("topic")) {
                topic = value;
                continue;
            }
            if (name.equals("group")) {
                group = value;
                continue;
            }
            if (name.equals("key")) {
                key = value;
                continue;
            }
            if (name.equals("persistence")) {
                persistence = Boolean.valueOf(value);
                continue;
            }
            if (name.equals("waterMark")) {
                waterMark = Integer.parseInt(value);
                continue;
            }
            if (name.equals("exchangeType")) {
                exchangeType = ExchangeType.valueOf(value);
                continue;
            }
            if (!name.equals("priority")) continue;
            priority = Integer.parseInt(value);
        }
        Binding binding = new Binding(exchangeType, topic, key, group, waterMark, persistence, Binding.checkAndModifyPriority(priority));
        return binding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Binding ");
        sb.append("topic=`").append(this.topic).append("` ");
        sb.append("key=`").append(this.key).append("` ");
        sb.append("exchangeType=`").append(this.exchangeType.name()).append("` ");
        sb.append("waterMark=`").append(this.waterMark).append("` ");
        sb.append("group=`").append(this.group).append("` ");
        sb.append("persistence=`").append(this.persistence).append("` ");
        sb.append("priority=`").append(this.priority).append("`]");
        return sb.toString();
    }

    @Override
    public int compareTo(Binding other) {
        if (other == null) {
            return 1;
        }
        return new CompareToBuilder().append((Object)this.exchangeType, (Object)other.exchangeType).append((Object)this.topic, (Object)other.topic).append((Object)this.group, (Object)other.group).append((Object)this.key, (Object)other.key).append(this.priority, other.priority).toComparison();
    }
}

