/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.subscription.eval;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.taobao.notify.message.StringMessage;
import com.taobao.notify.subscription.eval.MessagePropertiesParser;
import com.taobao.notify.subscription.eval.NotifyMessageMatchException;
import com.taobao.notify.utils.UniqId;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageMatcher {
    static final Object[] args = new Object[0];
    static final Pattern pattern = Pattern.compile("property\\.([a-zA-Z_\\$]+?)\\s*([=><!]+)\\s*([\\da-zA-Z\\.]+)\\s*");
    static final Pattern nilPattern = Pattern.compile("property\\.([a-zA-Z_\\$]+?)\\s*([=><!]+)\\s*'nil'\\s*");
    private static StringMessage mockMessage = new StringMessage();
    public static final Map<String, Object> messageProperties;

    public static boolean match(Map<String, Object> properties, Expression exp) {
        Object result = null;
        try {
            result = exp.execute(properties);
        }
        catch (Throwable t) {
            throw new NotifyMessageMatchException(t);
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new NotifyMessageMatchException("\u975e\u903b\u8f91\u8868\u8fbe\u5f0f\uff0c\u8868\u8fbe\u5f0f\u9700\u8981\u8fd4\u56deboolean\u503c");
    }

    public static Expression getCompiledExpression(String expression) {
        if (expression == null) {
            throw new NotifyMessageMatchException("Null expression");
        }
        expression = MessageMatcher.preprocessExpression(expression);
        try {
            return AviatorEvaluator.compile((String)expression, (boolean)true);
        }
        catch (Throwable t) {
            throw new NotifyMessageMatchException(t);
        }
    }

    private static String preprocessExpression(String expression) {
        Matcher matcher = pattern.matcher(expression);
        String s1 = matcher.replaceAll("property.$1$2'$3'");
        matcher = nilPattern.matcher(s1);
        return matcher.replaceAll("property.$1$2nil");
    }

    public static void verify(String expression) {
        if (expression == null) {
            throw new NotifyMessageMatchException("Null expression");
        }
        Expression exp = MessageMatcher.getCompiledExpression(expression);
        MessageMatcher.match(messageProperties, exp);
    }

    static {
        mockMessage.setMessageId(UniqId.getInstance().getUniqIDHash());
        mockMessage.setTopic("topic");
        mockMessage.setGroupId("group1");
        mockMessage.setMessageType("messageType1");
        mockMessage.setCommitted(true);
        mockMessage.setDLQTime(1000);
        mockMessage.setPostDelayTime(20000L);
        mockMessage.setClientPostTimeout(3000);
        mockMessage.setPriority(4);
        mockMessage.setTimeToLive(2000);
        mockMessage.setSendOnceMessage(true);
        mockMessage.setBody("hello");
        mockMessage.setBooleanProperty("boolean", true);
        mockMessage.setByteProperty("byte", (byte)0);
        mockMessage.setStringProperty("string", "hello world");
        mockMessage.setFloatProperty("float", 3.15f);
        mockMessage.setDoubleProperty("double", 3.15);
        mockMessage.setIntProperty("int", 2009);
        mockMessage.setShortProperty("short", (short)456);
        mockMessage.setLongProperty("long", 2L);
        messageProperties = MessagePropertiesParser.getMessageProperties(mockMessage);
    }
}

