/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.tools;

import com.taobao.notify.message.Message;
import com.taobao.notify.tools.BooleanUtils;

public class FlagTranslator {
    public static Message.MessageClassType getConcreteType(int flag) {
        return Message.MessageClassType.parseByte((byte)(flag & 1));
    }

    public static int setBackConcreteType(int flag, Message.MessageClassType type) {
        if (type == Message.MessageClassType.ObjectMessage || type == Message.MessageClassType.StreamMessage) {
            throw new IllegalArgumentException(type.name() + "\u65e0\u6cd5\u8bbe\u7f6e\u4e3aConcreteType");
        }
        flag = flag & 0xFFFFFFFE | type.toByte();
        return flag;
    }

    public static Message.MessageClassType getOriginType(int flag) {
        byte newType = (byte)((flag & 0x1800) >> 11);
        if (newType > 0) {
            switch (newType) {
                case 1: {
                    return Message.MessageClassType.PackagedMessage;
                }
                case 2: {
                    return Message.MessageClassType.ObjectMessage;
                }
                case 3: {
                    return Message.MessageClassType.StreamMessage;
                }
            }
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u7c7b\u578b\u5b57\u8282" + newType);
        }
        byte origninBit = (byte)((flag & 2) >> 1);
        return Message.MessageClassType.parseByte(origninBit);
    }

    public static int setBackOriginType(int flag, Message.MessageClassType type) {
        switch (type) {
            case StringMessage: 
            case BytesMessage: {
                flag = flag & 0xFFFFFFFD | type.toByte() << 1;
                return flag;
            }
            case ObjectMessage: 
            case PackagedMessage: 
            case StreamMessage: {
                flag = flag & 0xFFFFE7FF | type.toByte() << 11;
                return flag;
            }
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u7684MessageClassType");
    }

    public static Message.CompressMode getCompressMode(int flag) {
        return Message.CompressMode.parseByte((byte)((flag & 0x1C) >> 2));
    }

    public static int setBackCompressMode(int flag, Message.CompressMode mode) {
        flag = flag & 0xFFFFFFE3 | mode.toByte() << 2;
        return flag;
    }

    public static Message.Charset getCharset(int flag) {
        return Message.Charset.parseByte((byte)((flag & 0x3E0) >> 5));
    }

    public static int setBackCharset(int flag, Message.Charset charset) {
        flag = flag & 0xFFFFC1F | charset.toByte() << 5;
        return flag;
    }

    public static boolean isSendOnceMessage(int flag) {
        int value = (flag & 0x400) >> 10;
        return BooleanUtils.toBoolean(value);
    }

    public static int setBackSendOnceMessage(int flag, boolean sendOnceMessage) {
        int value = BooleanUtils.toInteger(sendOnceMessage);
        flag = flag & 0xFFFFFBFF | value << 10;
        return flag;
    }
}

