/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.loader.util;

import com.taobao.pandora.loader.archive.Archive;
import com.taobao.pandora.loader.archive.ExplodedArchive;
import com.taobao.pandora.loader.archive.JarFileArchive;
import com.taobao.pandora.loader.jar.Handler;
import com.taobao.pandora.loader.jar.JarFile;
import com.taobao.pandora.loader.util.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class ArchiveUtils {
    public static final String SEPARATOR = "!/";

    public static Archive createArchiveFromUrl(URL url) throws IOException {
        if (ResourceUtils.isFileURL(url)) {
            File file = ResourceUtils.getFile(url);
            if (file.isDirectory()) {
                return new ExplodedArchive(file);
            }
            return new JarFileArchive(file);
        }
        Handler handler = new Handler();
        JarFile rootJarFile = handler.getRootJarFileFromUrl(url);
        Archive parentArchive = new JarFileArchive(rootJarFile);
        while (true) {
            String substring;
            if ((substring = url.toString().substring(parentArchive.getUrl().toString().length())).isEmpty()) {
                return parentArchive;
            }
            int sepratorIndex = substring.indexOf(SEPARATOR);
            if (sepratorIndex == -1) break;
            final String entryName = substring.substring(0, sepratorIndex);
            List<Archive> nestedArchives = parentArchive.getNestedArchives(new Archive.EntryFilter(){

                @Override
                public boolean matches(Archive.Entry entry) {
                    if (entry.getName().equals(entryName)) {
                        return true;
                    }
                    return entry.isDirectory() && entry.getName().equals(entryName + '/');
                }
            });
            if (nestedArchives.isEmpty()) continue;
            parentArchive = nestedArchives.get(0);
        }
        return parentArchive;
    }
}

