/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.parser;

import com.taobao.tddl.common.util.GoogleConcurrentLruCache;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.sqlobjecttree.DMLCommon;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class ParserCache {
    private static final ParserCache instance = new ParserCache();
    public final int capacity;
    private final GoogleConcurrentLruCache<String, ItemValue> map;
    private final ReentrantLock lock = new ReentrantLock();

    private ParserCache() {
        int size = 389;
        String propSize = System.getProperty("com.taobao.tddl.parser.cachesize");
        if (propSize != null) {
            try {
                size = Integer.parseInt(propSize);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.capacity = size;
        this.map = new GoogleConcurrentLruCache(this.capacity);
    }

    public static final ParserCache instance() {
        return instance;
    }

    public int size() {
        return this.map.size();
    }

    protected ItemValue get(String sql) {
        return (ItemValue)this.map.get((Object)sql);
    }

    public SqlType getSqlType(String sql) {
        ItemValue itemValue = this.get(sql);
        if (itemValue != null) {
            return itemValue.getSqlType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlType setSqlTypeIfAbsent(String sql, SqlType sqlType) {
        ItemValue itemValue = this.get(sql);
        SqlType returnSqlType = null;
        if (itemValue == null) {
            this.lock.lock();
            try {
                itemValue = this.get(sql);
                if (itemValue == null) {
                    itemValue = new ItemValue();
                    this.put(sql, itemValue);
                }
            }
            finally {
                this.lock.unlock();
            }
            returnSqlType = itemValue.setSqlTypeIfAbsent(sqlType);
        } else {
            returnSqlType = itemValue.getSqlType() == null ? itemValue.setSqlTypeIfAbsent(sqlType) : itemValue.getSqlType();
        }
        return returnSqlType;
    }

    public FutureTask<DMLCommon> getFutureTask(String sql) {
        ItemValue itemValue = this.get(sql);
        if (itemValue != null) {
            return itemValue.getFutureDMLCommon();
        }
        return null;
    }

    public List<Object> getTableNameReplacement(String sql) {
        ItemValue itemValue = this.get(sql);
        if (itemValue != null) {
            return itemValue.getTableNameReplacement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> setTableNameReplacementIfAbsent(String sql, List<Object> tablenameReplacement) {
        ItemValue itemValue = this.get(sql);
        List<Object> returnList = null;
        if (itemValue == null) {
            this.lock.lock();
            try {
                itemValue = this.get(sql);
                if (itemValue == null) {
                    itemValue = new ItemValue();
                    this.put(sql, itemValue);
                }
            }
            finally {
                this.lock.unlock();
            }
            returnList = itemValue.setTableNameReplacementIfAbsent(tablenameReplacement);
        } else {
            returnList = itemValue.getTableNameReplacement() == null ? itemValue.setTableNameReplacementIfAbsent(tablenameReplacement) : itemValue.getTableNameReplacement();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureTask<DMLCommon> setFutureTaskIfAbsent(String sql, FutureTask<DMLCommon> future) {
        ItemValue itemValue = this.get(sql);
        FutureTask<DMLCommon> returnFutureTask = null;
        if (itemValue == null) {
            this.lock.lock();
            try {
                itemValue = this.get(sql);
                if (itemValue == null) {
                    itemValue = new ItemValue();
                    this.put(sql, itemValue);
                }
            }
            finally {
                this.lock.unlock();
            }
            returnFutureTask = itemValue.setFutureDMLCommonIfAbsent(future);
        } else {
            returnFutureTask = itemValue.getFutureDMLCommon() == null ? itemValue.setFutureDMLCommonIfAbsent(future) : itemValue.getFutureDMLCommon();
        }
        return returnFutureTask;
    }

    protected void put(String sql, ItemValue itemValue) {
        this.map.put((Object)sql, (Object)itemValue);
    }

    protected static class ItemValue {
        private AtomicReference<SqlType> sqlType = new AtomicReference();
        private AtomicReference<List<Object>> tableNameReplacement = new AtomicReference();
        private AtomicReference<FutureTask<DMLCommon>> futureDMLCommon = new AtomicReference();

        protected ItemValue() {
        }

        public SqlType getSqlType() {
            return this.sqlType.get();
        }

        public SqlType setSqlTypeIfAbsent(SqlType sqlTypeinput) {
            if (this.sqlType.compareAndSet(null, sqlTypeinput)) {
                return sqlTypeinput;
            }
            return this.sqlType.get();
        }

        public List<Object> getTableNameReplacement() {
            return this.tableNameReplacement.get();
        }

        public List<Object> setTableNameReplacementIfAbsent(List<Object> tableNameReplacementList) {
            if (this.tableNameReplacement.compareAndSet(null, tableNameReplacementList)) {
                return tableNameReplacementList;
            }
            return this.tableNameReplacement.get();
        }

        public FutureTask<DMLCommon> getFutureDMLCommon() {
            return this.futureDMLCommon.get();
        }

        public FutureTask<DMLCommon> setFutureDMLCommonIfAbsent(FutureTask<DMLCommon> future) {
            if (this.futureDMLCommon.compareAndSet(null, future)) {
                return future;
            }
            return this.futureDMLCommon.get();
        }
    }
}

