/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.parser;

import com.taobao.tddl.common.Monitor;
import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.common.util.NagiosUtils;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.parser.AntlrStringStream;
import com.taobao.tddl.parser.ParserCache;
import com.taobao.tddl.parser.SQLParser;
import com.taobao.tddl.parser.mysql.MySQLParserLexer;
import com.taobao.tddl.parser.mysql.MySQLParserParser;
import com.taobao.tddl.parser.mysql.MySQLWalker;
import com.taobao.tddl.parser.oracle.OracleParserLexer;
import com.taobao.tddl.parser.oracle.OracleParserParser;
import com.taobao.tddl.parser.oracle.OracleWalker;
import com.taobao.tddl.sqlobjecttree.DMLCommon;
import com.taobao.tddl.sqlobjecttree.OrderByEle;
import com.taobao.tddl.sqlobjecttree.SqlAndTableAtParser;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import com.taobao.tddl.sqlobjecttree.Statement;
import com.taobao.tddl.sqlobjecttree.mysql.function.MySQLConsistStringRegister;
import com.taobao.tddl.sqlobjecttree.mysql.function.MySQLFunctionRegister;
import com.taobao.tddl.sqlobjecttree.oracle.function.OracleConsistStringRegister;
import com.taobao.tddl.sqlobjecttree.oracle.function.OracleFunctionRegister;
import com.taobao.tddl.sqlobjecttree.oracle.function.OracleHintRegister;
import com.taobao.tddl.sqlobjecttree.outputhandlerimpl.HandlerContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLParserImp
implements SQLParser {
    private static final Log log = LogFactory.getLog(SQLParserImp.class);
    private final ParserCache globalCache = ParserCache.instance();

    public DMLCommon parseSQL(String sql) {
        return this.nestedParseSql(sql, true);
    }

    public DMLCommon parseSQL(String sql, boolean isMysql) {
        return this.nestedParseSql(sql, isMysql);
    }

    private DMLCommon nestedParseSql(final String sql, final boolean isMysql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null");
        }
        FutureTask<DMLCommon> future = this.globalCache.getFutureTask(sql);
        if (future == null) {
            Callable<DMLCommon> handle = new Callable<DMLCommon>(){

                @Override
                public DMLCommon call() throws Exception {
                    DMLCommon com = SQLParserImp.this.getDMLCommonObject(sql, isMysql);
                    com.init();
                    log.info((Object)"successfully parse a sql");
                    log.info((Object)("original sql:" + sql));
                    StringBuilder sb = new StringBuilder();
                    com.appendSQL(sb);
                    log.info((Object)("parsed sql:" + sb.toString()));
                    return com;
                }
            };
            future = new FutureTask<DMLCommon>(handle);
            future = this.globalCache.setFutureTaskIfAbsent(sql, future);
            future.run();
        }
        DMLCommon dmlcommon = null;
        try {
            dmlcommon = future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dmlcommon;
    }

    private DMLCommon getDMLCommonObject(String sql, boolean isMysql) {
        DMLCommon com;
        try {
            AntlrStringStream st = new AntlrStringStream(sql);
            if (isMysql) {
                MySQLWalker.beg_return ret = null;
                MySQLParserLexer pl = new MySQLParserLexer((CharStream)st);
                TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)pl);
                MySQLParserParser pa = new MySQLParserParser((TokenStream)tokens);
                pa.setFunc(MySQLFunctionRegister.reg);
                pa.setConsist(MySQLConsistStringRegister.reg);
                MySQLParserParser.beg_return beg = null;
                beg = pa.beg();
                CommonTree tree = (CommonTree)beg.getTree();
                log.debug((Object)tree.toStringTree());
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                nodes.setTokenStream((TokenStream)tokens);
                MySQLWalker walker = new MySQLWalker((TreeNodeStream)nodes);
                walker.setFunc(MySQLFunctionRegister.reg);
                walker.setConsist(MySQLConsistStringRegister.reg);
                ret = walker.beg();
                com = ret.obj;
            } else {
                OracleWalker.beg_return ret = null;
                OracleParserLexer pl = new OracleParserLexer((CharStream)st);
                TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)pl);
                OracleParserParser pa = new OracleParserParser((TokenStream)tokens);
                pa.setFunc(OracleFunctionRegister.reg);
                pa.setOracleHint(OracleHintRegister.reg);
                pa.setConsist(OracleConsistStringRegister.reg);
                OracleParserParser.beg_return beg = null;
                beg = pa.beg();
                CommonTree tree = (CommonTree)beg.getTree();
                log.debug((Object)tree.toStringTree());
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                nodes.setTokenStream((TokenStream)tokens);
                OracleWalker walker = new OracleWalker((TreeNodeStream)nodes);
                walker.setFunc(OracleFunctionRegister.reg);
                walker.setConsist(OracleConsistStringRegister.reg);
                walker.setOracleHint(OracleHintRegister.reg);
                ret = walker.beg();
                com = ret.obj;
            }
        }
        catch (RecognitionException e) {
            NagiosUtils.addNagiosLog((String)"SQL_PARSE_FAIL", (int)1);
            throw new RuntimeException("\u5206\u6790sql\u9519\u8bef\uff0c\u9519\u8bef\u7684sql\u662f:" + sql, e);
        }
        return com;
    }

    public Statement getStatement(String sql) {
        try {
            FutureTask<DMLCommon> future = this.globalCache.getFutureTask(sql);
            if (future == null) {
                return null;
            }
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Comparative> eval(String sql, List<Object> argument, Set<String> partnation) {
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return Collections.emptyMap();
            }
            return dmlc.getColumnsMap(argument, partnation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getTableName(String sql) {
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return null;
            }
            return dmlc.getTableName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getLimitFrom(String sql, List<Object> param) {
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return -1000L;
            }
            return dmlc.getSkip(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getLimitTo(String sql, List<Object> param) {
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return -1000L;
            }
            return dmlc.getMax(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<OrderByEle> getOrderByList(String sql) {
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return Collections.emptyList();
            }
            return dmlc.getOrderByEles();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<SqlAndTableAtParser> getSqlReadyToRun(String sql, Set<Map<String, String>> tables, List<Object> args, HandlerContainer handlerContainer) {
        if (sql == null) {
            throw new IllegalArgumentException("\u76ee\u6807sql\u4e3a\u7a7a");
        }
        try {
            DMLCommon dmlc = (DMLCommon)this.getStatement(sql);
            if (dmlc == null) {
                return Collections.emptyList();
            }
            return dmlc.getSqlReadyToRun(tables, args, handlerContainer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SqlParserResult parse(String sql, boolean isMySQL) {
        DMLCommon com = this.parseSQL(sql, isMySQL);
        Set<String> table = null;
        try {
            if (com == null) {
                com = this.parseSQL(sql, isMySQL);
                table = com.getTableName();
                Monitor.add((String)Monitor.buildTableKey1((String)table.toString()), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"PARSE_SQL_SUCCESS", (long)0L, (long)1L);
            } else {
                table = com.getTableName();
                Monitor.add((String)Monitor.buildTableKey1((String)table.toString()), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"PARSE_SQL_SUCCESS", (long)1L, (long)1L);
            }
        }
        catch (ClassCastException e) {
            throw new NotSupportException(e.getMessage() + ".not support yet");
        }
        return com;
    }
}

