/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree;

import com.taobao.tddl.common.sqlobjecttree.Column;
import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.sqlobjecttree.Function;
import com.taobao.tddl.sqlobjecttree.GroupFunctionType;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.ColumnImp;
import com.taobao.tddl.sqlobjecttree.common.value.function.Avg;
import com.taobao.tddl.sqlobjecttree.common.value.function.Count;
import com.taobao.tddl.sqlobjecttree.common.value.function.Max;
import com.taobao.tddl.sqlobjecttree.common.value.function.Min;
import com.taobao.tddl.sqlobjecttree.common.value.function.Sum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Columns
implements SQLFragment {
    private List<Column> columns = new ArrayList<Column>();
    private static final Map<Class<? extends Function>, GroupFunctionType> groupfunc = new HashMap<Class<? extends Function>, GroupFunctionType>();

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public GroupFunctionType getSelectType() {
        for (Column col : this.columns) {
            GroupFunctionType type = groupfunc.get(col.getNestClass());
            if (type == null) continue;
            if (this.columns.size() == 1) {
                return type;
            }
            return GroupFunctionType.NORMAL;
        }
        return GroupFunctionType.NORMAL;
    }

    public List<Column> getColumnsList() {
        return this.columns;
    }

    public void setColumns(Column[] columns) {
        this.columns.addAll(Arrays.asList(columns));
    }

    public void setColumns(Collection<Column> cols) {
        this.columns.addAll(cols);
    }

    public void addColumn(String table, String col, String alias) {
        this.columns.add(new ColumnImp(table, col, alias));
    }

    public void addColumn(Column col) {
        this.columns.add(col);
    }

    public void addColumnTabAndCol(String tab, String col) {
        this.columns.add(new ColumnImp(tab, col, null));
    }

    public void appendSQL(StringBuilder sb) {
        boolean firstElement = true;
        for (Column col : this.columns) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(",");
            }
            Utils.appendSQLList(col, sb);
        }
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        boolean firstElement = true;
        for (Column col : this.columns) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(",");
            }
            sb = Utils.appendSQLListWithList(oraTabName, col, sb, list);
        }
        return sb;
    }

    public void appendAliasToColumnMap(Map<String, SQLFragment> sqlAliasMap) {
        for (Column col : this.columns) {
            if (col.getAlias() == null) continue;
            sqlAliasMap.put(col.getAlias().toUpperCase(), (SQLFragment)col);
        }
    }

    public List<String> getColList2Str() {
        List<Column> list = this.getColumnsList();
        ArrayList<String> colList2Str = new ArrayList<String>();
        for (Column col : list) {
            col.toString();
            StringBuilder sb = new StringBuilder();
            col.appendSQL(sb);
            colList2Str.add(sb.toString().trim());
        }
        return colList2Str;
    }

    static {
        groupfunc.put(Count.class, GroupFunctionType.COUNT);
        groupfunc.put(Max.class, GroupFunctionType.MAX);
        groupfunc.put(Min.class, GroupFunctionType.MIN);
        groupfunc.put(Avg.class, GroupFunctionType.AVG);
        groupfunc.put(Sum.class, GroupFunctionType.SUM);
    }
}

