/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree;

import com.taobao.tddl.common.sqlobjecttree.Column;
import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeBaseList;
import com.taobao.tddl.sqlobjecttree.BindIndexHolder;
import com.taobao.tddl.sqlobjecttree.Constant;
import com.taobao.tddl.sqlobjecttree.Distinct;
import com.taobao.tddl.sqlobjecttree.Expression;
import com.taobao.tddl.sqlobjecttree.GroupFunctionType;
import com.taobao.tddl.sqlobjecttree.Hint;
import com.taobao.tddl.sqlobjecttree.InExpressionObject;
import com.taobao.tddl.sqlobjecttree.MaxWrapper;
import com.taobao.tddl.sqlobjecttree.OrderByEle;
import com.taobao.tddl.sqlobjecttree.PageWrapper;
import com.taobao.tddl.sqlobjecttree.PageWrapperCommon;
import com.taobao.tddl.sqlobjecttree.RangeWrapper;
import com.taobao.tddl.sqlobjecttree.ReplacableWrapper;
import com.taobao.tddl.sqlobjecttree.Select;
import com.taobao.tddl.sqlobjecttree.SkipWrapper;
import com.taobao.tddl.sqlobjecttree.SqlAndTableAtParser;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import com.taobao.tddl.sqlobjecttree.Statement;
import com.taobao.tddl.sqlobjecttree.TableName;
import com.taobao.tddl.sqlobjecttree.WhereCondition;
import com.taobao.tddl.sqlobjecttree.common.TableNameSubQueryImp;
import com.taobao.tddl.sqlobjecttree.common.expression.ComparableExpression;
import com.taobao.tddl.sqlobjecttree.common.expression.ExpressionGroup;
import com.taobao.tddl.sqlobjecttree.common.expression.InExpression;
import com.taobao.tddl.sqlobjecttree.common.expression.NotInExpression;
import com.taobao.tddl.sqlobjecttree.common.expression.OrExpressionGroup;
import com.taobao.tddl.sqlobjecttree.common.value.BindVar;
import com.taobao.tddl.sqlobjecttree.common.value.UnknowValueObject;
import com.taobao.tddl.sqlobjecttree.outputhandlerimpl.HandlerContainer;
import com.taobao.tddl.sqlobjecttree.outputhandlerimpl.PlaceHolderReplaceHandler;
import com.taobao.tddl.sqlobjecttree.outputhandlerimpl.RangePlaceHandler;
import com.taobao.tddl.sqlobjecttree.traversalAction.GroupByTraversalAction;
import com.taobao.tddl.sqlobjecttree.traversalAction.OrderByTraversalAction;
import com.taobao.tddl.sqlobjecttree.traversalAction.TableNameTraversalAction;
import com.taobao.tddl.sqlobjecttree.traversalAction.TraversalSQLAction;
import com.taobao.tddl.sqlobjecttree.traversalAction.TraversalSQLEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DMLCommon
implements Statement,
SqlParserResult,
ComparativeMapChoicer {
    protected BindIndexHolder holder = new BindIndexHolder();
    protected List<OrderByEle> orderByEle = Collections.emptyList();
    protected List<OrderByEle> groupByEle = Collections.emptyList();
    protected List<InExpressionObject> inObjList = new ArrayList<InExpressionObject>(1);
    protected List<Hint> hints = new ArrayList<Hint>(1);
    protected volatile Map<String, SQLFragment> aliasToSQLFragementMap = new HashMap<String, SQLFragment>();
    protected volatile List<Map<String, Comparative>> repListMap = new ArrayList<Map<String, Comparative>>();
    protected final List<Object> modifiableList = new ArrayList<Object>(2);
    public static final int DEFAULT_SKIP_MAX = -1000;
    Set<String> tableName = null;
    protected List<TableName> tbNames = new ArrayList<TableName>(2);
    protected Distinct distinct = null;

    public DMLCommon(BindIndexHolder holder) {
        this.holder = holder;
    }

    public DMLCommon() {
    }

    public BindIndexHolder getIndexHolder() {
        return this.holder;
    }

    public final Map<String, Comparative> getColumnsMap(List<Object> arguments, Set<String> partnationSet) {
        HashMap<String, Comparative> copiedMap = new HashMap<String, Comparative>(partnationSet.size());
        for (String aArgument : partnationSet) {
            Comparative comparative = this.getColumnComparative(arguments, aArgument);
            if (comparative == null) continue;
            copiedMap.put(aArgument, comparative);
        }
        return copiedMap;
    }

    public Comparative getColumnComparative(List<Object> arguments, String aArgument) {
        Comparative res = null;
        String upperCaseArg = aArgument.toUpperCase();
        for (Map<String, Comparative> map : this.repListMap) {
            Comparative temp = map.get(upperCaseArg);
            if (temp == null) continue;
            if (res != null) {
                throw new IllegalArgumentException("\u4e0d\u5141\u8bb8\u5728\u591a\u5c42sql\u7684where\u6761\u4ef6\u4e2d\u51fa\u73b0\u591a\u4e2a\u51fa\u73b0\u5206\u5e93\u5b57\u6bb5\u7684\u70b9\u3002\u6709\u95ee\u9898\u7684\u5206\u5e93\u5b57\u6bb5\u662f\uff1a" + aArgument);
            }
            Comparative comparative = temp.getVal(arguments, this.aliasToSQLFragementMap);
            if (this.containsUnknowValueObject(comparative)) continue;
            res = comparative;
        }
        return res;
    }

    protected boolean containsUnknowValueObject(Comparative comparative) {
        List list;
        if (comparative.getValue() instanceof UnknowValueObject) {
            return true;
        }
        if (comparative instanceof ComparativeBaseList && (list = ((ComparativeBaseList)comparative).getList()) != null) {
            for (Comparative c : list) {
                if (!this.containsUnknowValueObject(c)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public List<TableName> getTbNames() {
        return this.tbNames;
    }

    public void addTable(TableName tableName) {
        this.tbNames.add(tableName);
    }

    public void init() {
        this.initAliasAndComparableMap(this.aliasToSQLFragementMap, this.repListMap);
        this.registerTraversalActionAndGet();
        this.registerUnmodifiableSqlOutputFragement();
    }

    public void registerTraversalActionAndGet() {
        ArrayList<TraversalSQLAction> traversalSQLActions = new ArrayList<TraversalSQLAction>();
        TableNameTraversalAction tbNameaction = new TableNameTraversalAction();
        traversalSQLActions.add(tbNameaction);
        OrderByTraversalAction orderby = new OrderByTraversalAction();
        traversalSQLActions.add(orderby);
        GroupByTraversalAction groupby = new GroupByTraversalAction();
        traversalSQLActions.add(groupby);
        this.traversalSQL(traversalSQLActions, null);
        this.tableName = tbNameaction.getTableName();
        this.orderByEle = orderby.getOrderByEles();
        this.groupByEle = groupby.getGroupByEles();
    }

    protected void registerUnmodifiableSqlOutputFragement() {
        StringBuilder sb = new StringBuilder();
        sb = this.regTableModifiable(this.tableName, this.modifiableList, sb);
        this.modifiableList.add(sb.toString());
    }

    @Override
    public List<OrderByEle> getOrderByEles() {
        return this.orderByEle;
    }

    @Override
    public List<OrderByEle> getGroupByEles() {
        return this.groupByEle;
    }

    public void buildAliasToTableAndColumnMapping(Map<String, SQLFragment> sqlAliasMap) {
        for (TableName name : this.tbNames) {
            name.appendAliasToSQLMap(sqlAliasMap);
        }
    }

    protected void initAliasAndComparableMap(Map<String, SQLFragment> aliasToSQLFragementMap, List<Map<String, Comparative>> repListMap) {
        this.buildAliasToTableAndColumnMapping(aliasToSQLFragementMap);
        boolean hasOneSubSelect = false;
        for (TableName name : this.tbNames) {
            if (!(name instanceof TableNameSubQueryImp)) continue;
            if (hasOneSubSelect) {
                throw new IllegalArgumentException("\u540c\u7ea7sql\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u4e2a\u5b50sql");
            }
            hasOneSubSelect = true;
            TableNameSubQueryImp subSql = (TableNameSubQueryImp)name;
            Select select = subSql.getSubSelect();
            select.initAliasAndComparableMap(aliasToSQLFragementMap, repListMap);
        }
        repListMap.add(this.getSubColumnsMap());
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        boolean hasMoreElement = false;
        for (TableName tbName : this.tbNames) {
            if (hasMoreElement) {
                sb.append(",");
            } else {
                hasMoreElement = true;
            }
            sb = tbName.regTableModifiable(oraTabName, list, sb);
        }
        sb.append(" ");
        return sb;
    }

    public boolean hasTable() {
        return this.tbNames.size() != 0;
    }

    protected abstract Map<String, Comparative> getSubColumnsMap();

    public void traversalSQL(List<TraversalSQLAction> traversalSQLActions, TraversalSQLEvent.StatementType type) {
        if (type != null) {
            DMLCommon.notifyAll(traversalSQLActions, this, type);
        } else {
            DMLCommon.notifyAll(traversalSQLActions, this, TraversalSQLEvent.StatementType.NORMAL);
        }
        WhereCondition where = this.getSubWhereCondition();
        if (where != null) {
            OrExpressionGroup expgrp = where.getExpGroup();
            this.traversalExpressionGroup(expgrp, traversalSQLActions);
        }
        for (TableName tbName : this.tbNames) {
            if (!(tbName instanceof TableNameSubQueryImp)) continue;
            Select select = ((TableNameSubQueryImp)tbName).getSubSelect();
            select.traversalSQL(traversalSQLActions, TraversalSQLEvent.StatementType.TABLE);
        }
    }

    protected void traversalExpressionGroup(ExpressionGroup expgrp, List<TraversalSQLAction> traversalSQLActions) {
        List<Expression> exps = expgrp.getExpressions();
        for (Expression exp : exps) {
            Object obj;
            if (exp instanceof ExpressionGroup) {
                this.traversalExpressionGroup((ExpressionGroup)exp, traversalSQLActions);
                continue;
            }
            if (exp instanceof ComparableExpression) {
                obj = ((ComparableExpression)exp).getRight();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                obj = ((ComparableExpression)exp).getLeft();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                continue;
            }
            if (exp instanceof InExpression) {
                obj = ((InExpression)exp).getRight();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                obj = ((InExpression)exp).getLeft();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                this.inExpressionHandle((InExpression)exp);
                continue;
            }
            if (exp instanceof NotInExpression) {
                obj = ((NotInExpression)exp).getRight();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                obj = ((NotInExpression)exp).getLeft();
                DMLCommon.whereArgumentHandler(traversalSQLActions, obj);
                continue;
            }
            throw new IllegalStateException("should not be here");
        }
    }

    private void inExpressionHandle(InExpression exp) {
        Column column = (Column)exp.getLeft();
        Object values = exp.getRight();
        if (values instanceof List) {
            StringBuilder expStr = new StringBuilder();
            exp.appendSQL(expStr);
            List valuesList = (List)values;
            if (valuesList.get(0) instanceof BindVar) {
                for (Object obj : valuesList) {
                    if (obj instanceof BindVar) continue;
                    return;
                }
                ArrayList<Integer> indexs = new ArrayList<Integer>(valuesList.size());
                List bvs = valuesList;
                for (BindVar bv : bvs) {
                    indexs.add(bv.getIndex());
                }
                this.inObjList.add(new InExpressionObject(column.getColumn(), column.getAlias(), indexs, null, expStr.toString()));
            } else {
                for (Object obj : valuesList) {
                    if (!(obj instanceof BindVar)) continue;
                    return;
                }
                ArrayList<Object> indexs = new ArrayList<Object>(valuesList.size());
                List bvs = valuesList;
                for (Object bv : bvs) {
                    indexs.add(bv);
                }
                this.inObjList.add(new InExpressionObject(column.getColumn(), column.getAlias(), null, indexs, expStr.toString()));
            }
        } else if (values instanceof Select) {
            // empty if block
        }
    }

    private static void whereArgumentHandler(List<TraversalSQLAction> traversalSQLActions, Object obj) {
        if (obj instanceof Select) {
            DMLCommon.notifyAll(traversalSQLActions, (Select)obj, TraversalSQLEvent.StatementType.WHERE);
        }
    }

    private static void notifyAll(List<TraversalSQLAction> travelsarSQLActions, DMLCommon dmlc, TraversalSQLEvent.StatementType type) {
        for (TraversalSQLAction action : travelsarSQLActions) {
            action.actionProformed(new TraversalSQLEvent(TraversalSQLEvent.StatementType.TABLE, dmlc));
        }
    }

    public abstract WhereCondition getSubWhereCondition();

    @Override
    public Set<String> getTableName() {
        return this.tableName == null ? Collections.EMPTY_SET : this.tableName;
    }

    protected int getRangeOrMax(List<Object> param) {
        int max = -1000;
        int temp = -1000;
        for (TableName tbName : this.tbNames) {
            if (!(tbName instanceof TableNameSubQueryImp) || (temp = ((TableNameSubQueryImp)tbName).getSubSelect().getRangeOrMax(param)) <= max) continue;
            max = temp;
        }
        return max;
    }

    @Override
    public int getSkip(List<Object> param) {
        int skip = -1000;
        int temp = -1000;
        for (TableName tbName : this.tbNames) {
            if (!(tbName instanceof TableNameSubQueryImp) || (temp = ((TableNameSubQueryImp)tbName).getSubSelect().getSkip(param)) <= skip) continue;
            skip = temp;
        }
        return skip;
    }

    public void appendSQL(StringBuilder sb) {
        boolean comma = false;
        for (TableName tbName : this.tbNames) {
            if (comma) {
                sb.append(",");
            }
            comma = true;
            tbName.appendSQL(sb);
        }
        sb.append(" ");
    }

    @Override
    public GroupFunctionType getGroupFuncType() {
        return GroupFunctionType.NORMAL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (TableName tbName : this.tbNames) {
            if (comma) {
                sb.append(",");
            }
            comma = true;
            if (Constant.useToString(tbName)) {
                sb.append(tbName.toString());
                continue;
            }
            tbName.appendSQL(sb);
        }
        sb.append(" ");
        return sb.toString();
    }

    @Override
    public List<SqlAndTableAtParser> getSqlReadyToRun(Collection<Map<String, String>> tables, List<Object> args, HandlerContainer handlerContainer) {
        if (tables == null) {
            throw new IllegalArgumentException("\u5f85\u66ff\u6362\u8868\u540d\u4e3a\u7a7a");
        }
        if (this.modifiableList.size() == 0) {
            throw new IllegalArgumentException("\u672a\u521d\u59cb\u5316\u6216sql\u4e0d\u80fd\u76f4\u63a5\u8f93\u51fa");
        }
        ArrayList<SqlAndTableAtParser> retSqls = new ArrayList<SqlAndTableAtParser>(tables.size());
        for (Map<String, String> table : tables) {
            Result result = this.process(table, args, this.modifiableList, this.tableName, handlerContainer);
            SqlAndTableAtParser sqlAndTableAtParser = new SqlAndTableAtParser();
            sqlAndTableAtParser.sql = result.resultSQL;
            sqlAndTableAtParser.table = table;
            sqlAndTableAtParser.modifiedMap = result.changeParam;
            retSqls.add(sqlAndTableAtParser);
        }
        return retSqls;
    }

    public Result process(Map<String, String> table, List<Object> args, List<Object> modifiableTableName, Set<String> originalTable, HandlerContainer handlerContainer) {
        boolean allowChangePageNumber = handlerContainer.isAllowChangePageNumber();
        if (allowChangePageNumber) {
            PageWrapperCommon skipPage = null;
            PageWrapperCommon maxOrMaxPage = null;
            for (Object obj : modifiableTableName) {
                if (obj instanceof SkipWrapper) {
                    if (skipPage == null) {
                        skipPage = (SkipWrapper)obj;
                        continue;
                    }
                    if (skipPage.getVal(args) >= ((SkipWrapper)obj).getVal(args)) continue;
                    skipPage = (SkipWrapper)obj;
                    continue;
                }
                if (!(obj instanceof MaxWrapper) && !(obj instanceof RangeWrapper)) continue;
                if (maxOrMaxPage == null) {
                    maxOrMaxPage = (PageWrapperCommon)obj;
                    continue;
                }
                if (maxOrMaxPage.getVal(args) >= ((PageWrapperCommon)obj).getVal(args)) continue;
                maxOrMaxPage = (PageWrapperCommon)obj;
            }
            if (skipPage != null) {
                skipPage.setCanBeChanged(true);
            }
            if (maxOrMaxPage != null) {
                maxOrMaxPage.setCanBeChanged(true);
            }
        }
        Map<Integer, Object> changeParam = null;
        StringBuilder sb = new StringBuilder();
        for (Object obj : modifiableTableName) {
            if (obj instanceof String) {
                sb.append(obj.toString());
                continue;
            }
            if (obj instanceof PageWrapper) {
                RangePlaceHandler rangePlaceHandler = handlerContainer.getRangePlaceHandler();
                if (changeParam == null) {
                    changeParam = new HashMap<Integer, Object>(2);
                }
                String str = rangePlaceHandler.changeValue((PageWrapper)obj, changeParam);
                sb.append(str);
                continue;
            }
            if (obj instanceof ReplacableWrapper) {
                PlaceHolderReplaceHandler placeHolderHandler = handlerContainer.getPlaceHolderPlaceHandler(obj);
                String replacedTable = placeHolderHandler.getReplacedString(table, (ReplacableWrapper)obj);
                sb.append(replacedTable);
                continue;
            }
            throw new IllegalStateException("should not be here");
        }
        if (changeParam == null) {
            changeParam = Collections.emptyMap();
        }
        Result result = new Result(changeParam, sb.toString());
        return result;
    }

    public abstract List<OrderByEle> nestGetOrderByList();

    public abstract List<OrderByEle> nestGetGroupByList();

    @Override
    public boolean isDML() {
        return true;
    }

    public void addHint(Hint hint) {
        this.hints.add(hint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getMax(List<Object> param) {
        int skip = this.getSkip(param);
        int max = -1000;
        int range = this.getRangeOrMax(param);
        if (range != -1000) {
            if (skip != -1000) {
                if (range < 0) throw new IllegalArgumentException("max\u6216range\u503c\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u503c");
                if (skip < 0) throw new IllegalArgumentException("skip\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u503c");
                max = skip + range;
            } else {
                max = range;
            }
        }
        if (skip >= 0 || skip == -1000) return max;
        throw new IllegalArgumentException("skip\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u503c");
    }

    @Override
    public ComparativeMapChoicer getComparativeMapChoicer() {
        return this;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    @Override
    public List<String> getDistinctColumn() {
        if (null != this.distinct && null != this.distinct.getColumns()) {
            return this.distinct.getColumns().getColList2Str();
        }
        return null;
    }

    @Override
    public boolean hasHavingCondition() {
        return false;
    }

    @Override
    public List<InExpressionObject> getInExpressionObjectList() {
        return this.inObjList;
    }

    private static class Result {
        final Map<Integer, Object> changeParam;
        final String resultSQL;

        public Result(Map<Integer, Object> changeParam, String resultSQL) {
            this.changeParam = changeParam;
            this.resultSQL = resultSQL;
        }
    }
}

