/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common;

import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.sqlobjecttree.Function;
import com.taobao.tddl.sqlobjecttree.JoinClause;
import com.taobao.tddl.sqlobjecttree.TableName;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableNameFunctionImp
implements TableName {
    private String alias;
    private Function function;
    private boolean isOracle;

    public TableNameFunctionImp(Function func, String alias) {
        this.function = func;
        this.alias = alias;
    }

    public TableNameFunctionImp(Function func, String alias, boolean isOracle) {
        this.function = func;
        this.alias = alias;
        this.isOracle = isOracle;
    }

    @Override
    public void appendAliasToSQLMap(Map<String, SQLFragment> map) {
        if (this.alias != null) {
            map.put(this.alias.toUpperCase(), this);
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Set<String> getTableName() {
        throw new IllegalArgumentException("should not be here");
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void appendSQL(StringBuilder sb) {
        this.function.appendSQL(sb);
        if (this.alias != null) {
            sb.append(this.isOracle ? " " : " AS ");
            sb.append(this.alias);
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        sb = this.function.regTableModifiable(oraTabName, list, sb);
        if (this.alias != null) {
            sb.append(this.isOracle ? " " : " AS ");
            sb.append(this.alias);
        }
        return sb;
    }

    @Override
    public void setJoinClause(JoinClause joinClause) {
        if (joinClause != null) {
            throw new IllegalArgumentException(" not support join in Table function ");
        }
    }
}

