/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common;

import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.sqlobjecttree.JoinClause;
import com.taobao.tddl.sqlobjecttree.TableName;
import com.taobao.tddl.sqlobjecttree.TableWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableNameImp
implements TableName {
    private String alias;
    private String tablename;
    private String schemaName;
    private boolean isOracle;
    private JoinClause joinClause;

    public TableNameImp() {
    }

    public TableNameImp(boolean isOracle) {
        this.isOracle = isOracle;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    @Override
    public Set<String> getTableName() {
        HashSet<String> tableNames = new HashSet<String>(2);
        tableNames.add(this.tablename);
        if (this.joinClause != null && this.joinClause.getTableName() != null) {
            tableNames.addAll(this.joinClause.getTableName().getTableName());
        }
        return tableNames;
    }

    public void appendSQL(StringBuilder sb) {
        if (this.getSchemaName() != null) {
            sb.append(this.schemaName).append(".");
        }
        sb.append(this.tablename);
        if (this.getAlias() != null) {
            sb.append(this.isOracle ? " " : " as ").append(this.getAlias());
        }
        if (this.joinClause != null) {
            this.joinClause.appendSQL(sb);
        }
    }

    public JoinClause getJoinClause() {
        return this.joinClause;
    }

    @Override
    public void setJoinClause(JoinClause joinClause) {
        this.joinClause = joinClause;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.schemaName).append(".").append(this.tablename);
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableNameImp)) {
            return false;
        }
        TableNameImp imp = (TableNameImp)obj;
        JoinClause joinClause = imp.getJoinClause();
        boolean joinEqual = false;
        joinEqual = joinClause == null ? joinClause == this.joinClause : joinClause.equals(this.joinClause);
        return imp.tablename.equals(this.tablename) && imp.schemaName.equals(this.schemaName) && joinEqual;
    }

    public String getTableNameStr() {
        return this.tablename;
    }

    public StringBuilder regTableModifiable(Set<String> logicTableNames, List<Object> list, StringBuilder sb) {
        if (this.getSchemaName() != null) {
            sb.append(this.schemaName).append(".");
        }
        if (this.tablename != null && logicTableNames.contains(this.tablename)) {
            list.add(sb.toString());
            TableWrapper wr = new TableWrapper();
            wr.setOriTable(this.tablename);
            list.add(wr);
            sb = new StringBuilder();
        } else if (this.tablename != null) {
            sb.append(this.tablename);
        } else {
            throw new IllegalArgumentException("\u8868\u540d\u5bf9\u8c61\u4e2d\u4e0d\u80fd\u7f3a\u5c11\u8868\u540d");
        }
        if (this.getAlias() != null) {
            sb.append(this.isOracle ? " " : " as ").append(this.getAlias());
        }
        if (this.joinClause != null) {
            this.joinClause.regTableModifiable(logicTableNames, list, sb);
        }
        return sb;
    }

    @Override
    public void appendAliasToSQLMap(Map<String, SQLFragment> map) {
        if (this.getAlias() != null) {
            map.put(this.getAlias().toUpperCase(), this);
        }
        if (this.joinClause != null) {
            this.joinClause.appendAliasToSQLMap(map);
        }
    }
}

