/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common;

import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.sqlobjecttree.JoinClause;
import com.taobao.tddl.sqlobjecttree.Select;
import com.taobao.tddl.sqlobjecttree.TableName;
import com.taobao.tddl.sqlobjecttree.Utils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableNameSubQueryImp
implements TableName {
    private String alias;
    private Select subSelect;
    private boolean isOracle;

    public TableNameSubQueryImp() {
    }

    public TableNameSubQueryImp(boolean isOracle) {
        this.isOracle = isOracle;
    }

    @Override
    public void setJoinClause(JoinClause joinClause) {
        if (joinClause != null) {
            throw new IllegalArgumentException(" not support join in subquery ");
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public Select getSubSelect() {
        return this.subSelect;
    }

    public void setSubSelect(Select subSelect) {
        this.subSelect = subSelect;
    }

    public void appendSQL(StringBuilder sb) {
        Utils.appendSQLList(this.subSelect, sb);
        if (this.alias != null) {
            sb.append(" ");
            sb.append(this.alias);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subSelect.toString());
        if (this.alias != null) {
            sb.append(this.isOracle ? " " : " AS ");
            sb.append(this.alias);
        }
        return sb.toString();
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Set<String> getTableName() {
        throw new IllegalArgumentException("should not be here");
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        sb = Utils.appendSQLListWithList(oraTabName, this.subSelect, sb, list);
        if (this.alias != null) {
            sb.append(this.isOracle ? " " : " as ");
            sb.append(this.alias);
        }
        return sb;
    }

    @Override
    public void appendAliasToSQLMap(Map<String, SQLFragment> map) {
        this.getSubSelect().buildAliasToTableAndColumnMapping(map);
        if (this.getAlias() != null) {
            map.put(this.getAlias().toUpperCase(), this);
        }
    }
}

