/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common.expression;

import com.taobao.tddl.common.sqlobjecttree.Column;
import com.taobao.tddl.common.sqlobjecttree.Value;
import com.taobao.tddl.sqlobjecttree.Expression;
import com.taobao.tddl.sqlobjecttree.Function;
import com.taobao.tddl.sqlobjecttree.RowJepVisitor;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.ComparableElement;
import com.taobao.tddl.sqlobjecttree.common.value.UnknowValueObject;
import java.util.List;
import java.util.Set;

public abstract class ComparableExpression
implements Expression {
    private boolean rownum;
    protected Object left;
    protected Object right;

    protected abstract int getComparativeOperation();

    public abstract String getRelationString();

    public void appendSQL(StringBuilder sb) {
        Utils.appendSQLList(this.left, sb);
        sb.append(this.getRelationString());
        Utils.appendSQLList(this.right, sb);
    }

    @Override
    public void eval(RowJepVisitor visitor, boolean inAnd) {
        String colName = null;
        if (this.left instanceof Column) {
            colName = ((Column)this.left).getColumn();
        } else if (this.left instanceof Function) {
            colName = ((Function)this.left).getNestedColName();
        }
        int operator = this.getComparativeOperation();
        if (this.right instanceof Value) {
            Value val = (Value)this.right;
            Comparable temp = val.eval();
            if (colName == null) {
                throw new IllegalArgumentException("sql\u5143\u7d20\uff1a" + this.left + "|" + this.getRelationString() + "|" + this.right + "\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u7684\u5217\u540d,\u76ee\u524d\u53ea\u652f\u6301\u5217\u540d\u5b57\u6bb5\u5728\u8868\u8fbe\u5f0f\u5de6\u8fb9");
            }
            visitor.put(colName.toUpperCase(), new ComparableElement(temp, inAnd, operator));
        } else if (colName == null) {
            if (this.right instanceof Column) {
                throw new IllegalArgumentException("sql\u5143\u7d20\uff1a" + this.left + "|" + this.getRelationString() + "|" + this.right + "\u4e0d\u652f\u6301\u5217\u540d\u5199\u5728Comparative\u53f3\u8fb9");
            }
        } else if (this.right instanceof Comparable) {
            visitor.put(colName.toUpperCase(), new ComparableElement((Comparable)this.right, inAnd, operator));
        } else if (this.right == null) {
            visitor.put(colName.toUpperCase(), new ComparableElement((Comparable)this.right, inAnd, operator));
        } else {
            visitor.put(colName.toUpperCase(), new ComparableElement(UnknowValueObject.getUnknowValueObject(), inAnd, operator));
        }
    }

    public Object getLeft() {
        return this.left;
    }

    public void setLeft(Object left) {
        this.left = left;
    }

    public Object getRight() {
        return this.right;
    }

    public void setRight(Object right) {
        this.right = right;
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        sb = Utils.appendSQLListWithList(oraTabName, this.left, sb, list);
        sb.append(this.getRelationString());
        sb = Utils.appendSQLListWithList(oraTabName, this.right, sb, list);
        return sb;
    }

    public void setRownum(boolean rownum) {
        this.rownum = rownum;
    }

    public boolean isRownum() {
        return this.rownum;
    }
}

