/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common.expression;

import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.sqlobjecttree.Constant;
import com.taobao.tddl.sqlobjecttree.Expression;
import com.taobao.tddl.sqlobjecttree.RowJepVisitor;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.ComparableElement;
import com.taobao.tddl.sqlobjecttree.common.expression.ComparableExpression;
import com.taobao.tddl.sqlobjecttree.common.expression.OrExpressionGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionGroup
implements Expression {
    protected List<Expression> expressions = new ArrayList<Expression>();

    protected String getConjunction() {
        return " and ";
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public void addExpressionGroup(ExpressionGroup expGroup) {
        this.expressions.add(expGroup);
    }

    public void appendSQL(StringBuilder sb) {
        boolean appendSplitter = false;
        for (Expression expression : this.expressions) {
            if (appendSplitter) {
                sb.append(this.getConjunction());
            } else {
                appendSplitter = true;
            }
            if (expression instanceof OrExpressionGroup) {
                sb.append("(");
                Utils.appendSQL(expression, sb);
                sb.append(")");
                continue;
            }
            Utils.appendSQL(expression, sb);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean appendSplitter = false;
        for (Expression expression : this.expressions) {
            if (appendSplitter) {
                sb.append(this.getConjunction());
            } else {
                appendSplitter = true;
            }
            if (this instanceof OrExpressionGroup) {
                if (Constant.useToString(expression)) {
                    sb.append(expression.toString());
                    continue;
                }
                Utils.appendSQL(expression, sb);
                continue;
            }
            if (!Constant.useToString(expression)) {
                Utils.appendSQL(expression, sb);
                continue;
            }
            if (expression instanceof ComparableExpression) {
                sb.append(expression.toString());
                continue;
            }
            if (expression instanceof ExpressionGroup) {
                if (expression instanceof OrExpressionGroup) {
                    sb.append('(');
                    sb.append(expression.toString());
                    sb.append(')');
                    continue;
                }
                sb.append(expression.toString());
                continue;
            }
            sb.append(expression.toString());
        }
        return sb.toString();
    }

    @Override
    public void eval(RowJepVisitor visitor, boolean inAnd) {
        for (Expression e : this.expressions) {
            if (e instanceof OrExpressionGroup) {
                RowJepVisitor vis = new RowJepVisitor();
                e.eval(vis, true);
                Map<String, Comparative> mp = vis.getComparable();
                for (Map.Entry<String, Comparative> et : mp.entrySet()) {
                    visitor.put(et.getKey(), new ComparableElement((Comparable)et.getValue(), true, et.getValue().getComparison()));
                }
                continue;
            }
            e.eval(visitor, true);
        }
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        boolean appendSplitter = false;
        for (Expression expression : this.expressions) {
            if (appendSplitter) {
                sb.append(this.getConjunction());
            } else {
                appendSplitter = true;
            }
            if (expression instanceof OrExpressionGroup) {
                sb.append("(");
                sb = Utils.appendSQLWithList(oraTabName, expression, sb, list);
                sb.append(")");
                continue;
            }
            sb = Utils.appendSQLWithList(oraTabName, expression, sb, list);
        }
        return sb;
    }
}

