/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.common.expression;

import com.taobao.tddl.common.sqlobjecttree.Column;
import com.taobao.tddl.common.sqlobjecttree.Value;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import com.taobao.tddl.sqlobjecttree.Expression;
import com.taobao.tddl.sqlobjecttree.Function;
import com.taobao.tddl.sqlobjecttree.RowJepVisitor;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.value.UnknowValueObject;
import java.util.List;
import java.util.Set;

public class NotInExpression
implements Expression {
    protected Object left;
    protected Object right;

    protected int getComparativeOperation() {
        return 6;
    }

    public String getRelationString() {
        return " not in ";
    }

    public void appendSQL(StringBuilder sb) {
        Utils.appendSQLList(this.left, sb);
        sb.append(this.getRelationString());
        Utils.appendSQLList(this.right, sb);
    }

    @Override
    public void eval(RowJepVisitor visitor, boolean inAnd) {
        String colName = null;
        if (this.left instanceof Column) {
            colName = ((Column)this.left).getColumn();
        } else if (this.left instanceof Function) {
            colName = ((Function)this.left).getNestedColName();
        } else {
            throw new IllegalArgumentException("\u4e0d\u80fd\u627e\u5230\u5217\u540d\uff0c\u8bf7\u786e\u4fdd\u5217\u540d\u5728\u7b49\u5f0f\u5de6\u9762");
        }
        int operator = this.getComparativeOperation();
        ComparativeOR or = null;
        if (this.right instanceof List) {
            List li = (List)this.right;
            or = new ComparativeOR(li.size());
            for (Object obj : li) {
                this.buildOneEqComparative(or, obj, colName, false, operator);
            }
        } else if (this.right instanceof Value) {
            or = new ComparativeOR();
            this.buildOneEqComparative(or, this.right, colName, inAnd, operator);
        } else {
            throw new IllegalStateException("\u4e0d\u652f\u6301\u975elist\u6216select\u7684\u60c5\u51b5\uff0c\u8fd9\u53ef\u80fd\u662f\u7531\u4e8e\u4e0d\u662fin\u51fd\u6570\u5f15\u8d77\u7684");
        }
    }

    private void buildOneEqComparative(ComparativeOR comparativeOR, Object right, String colName, boolean inAnd, int operator) {
        if (right instanceof Value) {
            Value val = (Value)right;
            Comparable temp = val.eval();
            comparativeOR.addComparative(new Comparative(operator, temp));
        } else {
            if (colName == null) {
                throw new IllegalArgumentException("sql\u5143\u7d20\uff1a" + this.left + "|" + this.getRelationString() + "|" + right + "\u4e2d\u627e\u5230\u6307\u5b9a\u7684\u5217\u540d");
            }
            if (right instanceof Comparable) {
                comparativeOR.addComparative(new Comparative(operator, (Comparable)right));
            } else {
                comparativeOR.addComparative(new Comparative(operator, UnknowValueObject.getUnknowValueObject()));
            }
        }
    }

    public Object getLeft() {
        return this.left;
    }

    public void setLeft(Object left) {
        this.left = left;
    }

    public Object getRight() {
        return this.right;
    }

    public void setRight(Object right) {
        this.right = right;
    }

    public StringBuilder regTableModifiable(Set<String> oraTabName, List<Object> list, StringBuilder sb) {
        sb = Utils.appendSQLListWithList(oraTabName, this.left, sb, list);
        sb.append(this.getRelationString());
        sb = Utils.appendSQLListWithList(oraTabName, this.right, sb, list);
        return sb;
    }
}

