/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.mysql.function.datefunction;

import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.value.OperationBeforTwoArgsFunction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class StrToDate
extends OperationBeforTwoArgsFunction {
    private static final String[] dateNotSupport = new String[]{"%a", "%b", "%D"};
    private volatile DateFormat toDateFormat;

    @Override
    public String getFuncName() {
        return "STR_TO_DATE";
    }

    @Override
    public Comparable<?> getVal(List<Object> args) {
        Date returnDate;
        String timeArgument;
        DateFormat df;
        Comparable<?> obj = null;
        try {
            obj = Utils.getVal(args, this.arg2);
            String temp = (String)((Object)obj);
            df = this.getDF(temp);
            obj = Utils.getVal(args, this.arg1);
            timeArgument = (String)((Object)obj);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8f6c\u6362\u51fd\u6570\uff0c" + obj + "\u8be5\u53c2\u6570\u5fc5\u987b\u4e3aString");
        }
        try {
            returnDate = df.parse(timeArgument);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u65f6\u95f4\u51fd\u6570\uff0c\u5f53\u524d\u65f6\u95f4\u51fd\u6570String\u4e3a" + timeArgument, e);
        }
        return returnDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DateFormat getDF(String source) {
        if (this.toDateFormat == null) {
            StrToDate strToDate = this;
            synchronized (strToDate) {
                if (this.toDateFormat == null) {
                    String temp = StrToDate.replaceToJavaFormat(source);
                    this.toDateFormat = new SimpleDateFormat(temp);
                }
            }
        }
        return this.toDateFormat;
    }

    protected static final String replaceToJavaFormat(String source) {
        if (source == null) {
            return null;
        }
        for (String s : dateNotSupport) {
            if (!source.contains(s)) continue;
            throw new NotSupportException("mysql\u8f6c\u6362\u51fd\u6570\u4e0d\u652f\u6301\u4f7f\u7528\u5f53\u524d\u51fd\u6570:" + s + ",\u60a8\u8f93\u5165\u7684\u662f:" + source);
        }
        source = source.replaceAll("%Y", "yyyy");
        source = source.replaceAll("%y", "yy");
        source = source.replaceAll("%m", "MM");
        source = source.replaceAll("%c", "MM");
        source = source.replaceAll("%d", "dd");
        source = source.replaceAll("%H", "HH");
        source = source.replaceAll("%h", "hh");
        source = source.replaceAll("%I", "hh");
        source = source.replaceAll("%p", "aaa");
        source = source.replaceAll("%i", "mm");
        source = source.replaceAll("%s", "ss");
        source = source.replaceAll("%S", "ss");
        return source;
    }
}

