/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.oracle;

import com.taobao.tddl.common.sqlobjecttree.Column;
import com.taobao.tddl.common.sqlobjecttree.SQLFragment;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeAND;
import com.taobao.tddl.interact.sqljep.ComparativeOR;
import com.taobao.tddl.sqlobjecttree.Expression;
import com.taobao.tddl.sqlobjecttree.RowJepVisitor;
import com.taobao.tddl.sqlobjecttree.Select;
import com.taobao.tddl.sqlobjecttree.TableName;
import com.taobao.tddl.sqlobjecttree.common.TableNameSubQueryImp;
import com.taobao.tddl.sqlobjecttree.common.expression.ComparableExpression;
import com.taobao.tddl.sqlobjecttree.common.expression.ExpressionGroup;
import com.taobao.tddl.sqlobjecttree.common.expression.OrExpressionGroup;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class SkipMaxUtils {
    public static int getRowNumSkipToInt(Comparative co) {
        if (co == null) {
            return -1000;
        }
        if (co instanceof ComparativeAND) {
            int snapSkip = -1000;
            ComparativeAND coAnd = (ComparativeAND)co;
            List compList = coAnd.getList();
            for (Comparative c : compList) {
                int tempRowNum = SkipMaxUtils.getRowNumSkipToInt(c);
                if (tempRowNum == -1000 || tempRowNum <= snapSkip) continue;
                snapSkip = tempRowNum;
            }
            return snapSkip;
        }
        if (co instanceof ComparativeOR) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u4e00\u6761sql\u4e2drownum\u51fa\u73b0or\u7684\u60c5\u51b5");
        }
        if (co.getComparison() == 3 || co.getComparison() == 0) {
            throw new IllegalArgumentException("rownum\u76ee\u524d\u4e0d\u652f\u6301=\u5173\u7cfb");
        }
        if (co.getComparison() == 1) {
            return SkipMaxUtils.getComparativeToInt(co);
        }
        if (co.getComparison() == 2) {
            return SkipMaxUtils.getComparativeToInt(co) - 1;
        }
        return -1000;
    }

    public static int getRowNumMaxToInt(Comparative co) {
        if (co == null) {
            return -1000;
        }
        if (co instanceof ComparativeAND) {
            int snapSkip = -1000;
            ComparativeAND coAnd = (ComparativeAND)co;
            List compList = coAnd.getList();
            for (Comparative c : compList) {
                int tempRowNum = SkipMaxUtils.getRowNumMaxToInt(c);
                if (tempRowNum == -1000 || tempRowNum <= snapSkip) continue;
                snapSkip = tempRowNum;
            }
            return snapSkip;
        }
        if (co instanceof ComparativeOR) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u4e00\u6761sql\u4e2drownum\u51fa\u73b0or\u7684\u60c5\u51b5");
        }
        if (co.getComparison() == 3 || co.getComparison() == 0) {
            throw new IllegalArgumentException("rownum\u76ee\u524d\u4e0d\u652f\u6301=\u5173\u7cfb");
        }
        if (co.getComparison() == 7) {
            return SkipMaxUtils.getComparativeToInt(co) - 1;
        }
        if (co.getComparison() == 8) {
            return SkipMaxUtils.getComparativeToInt(co);
        }
        return -1000;
    }

    private static int getComparativeToInt(Comparative co) {
        Comparable ctemp = co.getValue();
        if (ctemp instanceof Integer) {
            return (Integer)ctemp;
        }
        if (ctemp instanceof BigDecimal) {
            return ((BigDecimal)ctemp).intValueExact();
        }
        throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301bigDecimal\u548cinteger\u7c7b\u578b\u7684rownum\u53c2\u6570,\u5f53\u524d\u53c2\u6570\u4e3a:" + ctemp.getClass() + "|" + ctemp);
    }

    protected static ComparativeAND buildRownumGroup(OrExpressionGroup orExpressionGroup, List<TableName> tbNames, Map<String, SQLFragment> aliasToSQLFragementMap) {
        ExpressionGroup rownum = new ExpressionGroup();
        SkipMaxUtils.nestedBuildRownumGroup(orExpressionGroup, tbNames, rownum, aliasToSQLFragementMap);
        RowJepVisitor visitor = new RowJepVisitor();
        rownum.eval(visitor, true);
        Map<String, Comparative> map = visitor.getComparable();
        ComparativeAND and = new ComparativeAND();
        for (Comparative com : map.values()) {
            and.addComparative(com);
        }
        return and;
    }

    public static void nestedBuildRownumGroup(ExpressionGroup source, List<TableName> tabNames, ExpressionGroup targetRownumGroup, Map<String, SQLFragment> aliasMap) {
        if (targetRownumGroup != null) {
            for (TableName tname : tabNames) {
                if (!(tname instanceof TableNameSubQueryImp)) continue;
                Select select = ((TableNameSubQueryImp)tname).getSubSelect();
                SkipMaxUtils.nestedBuildRownumGroup(select.getWhere().getExpGroup(), select.getTbNames(), targetRownumGroup, aliasMap);
            }
            SkipMaxUtils.putRowNumIntoRownumExpGroup(source, targetRownumGroup, aliasMap);
        }
    }

    protected static void putRowNumIntoRownumExpGroup(ExpressionGroup source, ExpressionGroup targetRowNumGroup, Map<String, SQLFragment> aliasMap) {
        List<Expression> exps = source.getExpressions();
        for (Expression exp : exps) {
            Object right;
            String colName;
            if (exp instanceof ExpressionGroup) {
                SkipMaxUtils.putRowNumIntoRownumExpGroup((ExpressionGroup)exp, targetRowNumGroup, aliasMap);
                continue;
            }
            if (!(exp instanceof ComparableExpression)) continue;
            Object left = ((ComparableExpression)exp).getLeft();
            if (left instanceof Column && (colName = ((Column)left).getColumn()) != null) {
                String tempCol;
                SkipMaxUtils.putRownumColumnToRownumExpression(targetRowNumGroup, exp, colName);
                SQLFragment fragement = aliasMap.get(colName.toUpperCase());
                if (fragement instanceof Column && (tempCol = ((Column)fragement).getColumn()) != null) {
                    SkipMaxUtils.putRownumColumnToRownumExpression(targetRowNumGroup, exp, tempCol);
                }
            }
            if (!((right = ((ComparableExpression)exp).getRight()) instanceof Select)) continue;
            Select select = (Select)right;
            SkipMaxUtils.nestedBuildRownumGroup(select.getWhere().getExpGroup(), select.getTbNames(), targetRowNumGroup, aliasMap);
        }
    }

    private static void putRownumColumnToRownumExpression(ExpressionGroup targetRowNumGroup, Expression exp, String colName) {
        if (colName.equalsIgnoreCase("rownum")) {
            targetRowNumGroup.addExpression(exp);
            ((ComparableExpression)exp).setRownum(true);
        }
    }
}

