/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.sqlobjecttree.oracle.function;

import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.sqlobjecttree.Utils;
import com.taobao.tddl.sqlobjecttree.common.value.OperationBeforTwoArgsFunction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ToDate
extends OperationBeforTwoArgsFunction {
    private static final String[] dateNotSupport = new String[]{"SSSSS", "SYYY", "IYYY", "RR", "YEAR", "SYEAR", "BC", "Q", "DAY", "FMDAY", "DY", "J"};
    private volatile DateFormat toDateFormat;

    @Override
    public String getFuncName() {
        return "TO_DATE";
    }

    @Override
    public Comparable<?> getVal(List<Object> args) {
        Date returnDate;
        String timeArgument;
        DateFormat df;
        Comparable<?> obj = null;
        try {
            obj = Utils.getVal(args, this.arg2);
            String temp = (String)((Object)obj);
            df = this.getDF(temp);
            obj = Utils.getVal(args, this.arg1);
            timeArgument = (String)((Object)obj);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u8f6c\u6362\u51fd\u6570\uff0c" + obj + "\u8be5\u53c2\u6570\u5fc5\u987b\u4e3aString");
        }
        try {
            returnDate = df.parse(timeArgument);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u65f6\u95f4\u51fd\u6570\uff0c\u5f53\u524d\u65f6\u95f4\u51fd\u6570String\u4e3a" + timeArgument, e);
        }
        return returnDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DateFormat getDF(String source) {
        if (this.toDateFormat == null) {
            ToDate toDate = this;
            synchronized (toDate) {
                if (this.toDateFormat == null) {
                    String temp = ToDate.replaceToJavaFormat(source);
                    this.toDateFormat = new SimpleDateFormat(temp);
                }
            }
        }
        return this.toDateFormat;
    }

    protected static final String replaceToJavaFormat(String source) {
        if (source == null) {
            return null;
        }
        source = source.toUpperCase();
        for (String s : dateNotSupport) {
            if (!source.contains(s)) continue;
            throw new NotSupportException("Oracle\u8f6c\u6362\u51fd\u6570\u4e0d\u652f\u6301\u4f7f\u7528\u5f53\u524d\u51fd\u6570:" + s + "\u60a8\u8f93\u5165\u7684\u662f:" + source);
        }
        source = source.replaceAll("YYYY", "yyyy");
        source = source.replaceAll("YY", "yy");
        source = source.replaceAll("MONTH", "MMMMM");
        source = source.replaceAll("MON", "MMM");
        source = source.replaceAll("WW", "www");
        source = source.replaceAll("DD", "dd");
        source = source.replaceAll("HH24", "kk");
        source = source.replaceAll("HH12", "hh");
        source = source.replaceAll("HH", "hh");
        source = source.replaceAll("AM", "aaa");
        source = source.replaceAll("PM", "aaa");
        source = source.replaceAll("MI", "mm");
        source = source.replaceAll("SS", "ss");
        return source;
    }
}

