/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.ValidatePipeline;
import com.tongweb.commons.license.validate.pipeline.valve.CreateDateValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.EndDateValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.HardwareIdValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.IPMatchValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.MacAddressValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.StartDateTimeValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.license.validate.pipeline.valve.VersionNumberValidatorValve;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseValidateService {
    private static final Log log = LogFactory.getLog(LicenseValidateService.class);
    private ValidatePipeline pipeline = new ValidatePipeline();

    public static LicenseValidateService initLocalValves() {
        LicenseValidateService validateService = new LicenseValidateService();
        if (validateService.getPipeline().isPipelineEmpty()) {
            validateService.getPipeline().registerValve((ValidatorValve)new VersionNumberValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new HardwareIdValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new CreateDateValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new StartDateTimeValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new EndDateValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new IPMatchValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new MacAddressValidatorValve());
        }
        return validateService;
    }

    public static LicenseValidateService initRemoteValves() {
        LicenseValidateService validateService = new LicenseValidateService();
        if (validateService.getPipeline().isPipelineEmpty()) {
            validateService.getPipeline().registerValve((ValidatorValve)new VersionNumberValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new CreateDateValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new StartDateTimeValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new EndDateValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new IPMatchValidatorValve());
            validateService.getPipeline().registerValve((ValidatorValve)new MacAddressValidatorValve());
        }
        return validateService;
    }

    private LicenseValidateService() {
    }

    public LicenseValidateService(ValidatorValve ... valves) {
        this.pipeline.registerValve(valves);
    }

    public Response validateForInstance(TongWebLicense license, Map<String, String> validationContext) {
        if (license == null) {
            log.error((Object)"license can not empty");
            return ResponseFactory.genErrorCodeResult(ResultCodeEnum.LICENSE_NOT_FOUND, "license can not empty");
        }
        return this.pipeline.validate(license, validationContext);
    }

    public Response validateForLicense(TongWebLicense license) {
        return this.pipeline.validate(license, null);
    }

    public ValidatePipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(ValidatePipeline pipeline) {
        this.pipeline = pipeline;
    }
}

