/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatePipeline {
    private static final Log log = LogFactory.getLog(ValidatePipeline.class);
    private List<ValidatorValve> valves = new ArrayList<ValidatorValve>();

    public void registerValve(ValidatorValve valve) {
        if (valve != null) {
            this.valves.add(valve);
        }
    }

    public void registerValve(ValidatorValve ... valves) {
        if (valves != null) {
            this.valves.addAll(Arrays.asList(valves));
        }
    }

    public boolean isPipelineEmpty() {
        return this.valves.isEmpty();
    }

    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        if (!this.isPipelineEmpty()) {
            try {
                for (ValidatorValve valve : this.valves) {
                    Response response = valve.validate(license, validationContext);
                    if (response.isResult() && response.getCode() == ResultCodeEnum.SUCCESS.getCode()) continue;
                    return response;
                }
                return ResponseFactory.genSuccessResult();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return ResponseFactory.genExceptionResult(e2.getMessage());
            }
        }
        log.fatal((Object)"validate pipeline can not empty");
        return ResponseFactory.genErrorCodeResult(ResultCodeEnum.VALIDATE_PIPELINE_EMPTY, "validate pipeline can not empty");
    }
}

