/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.utils.DateUtils;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateDateValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(CreateDateValidatorValve.class);

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        String createDate = license.getCreateDate();
        if (createDate != null && createDate.length() != 0) {
            try {
                if (DateUtils.isAfterNow(createDate)) {
                    log.fatal((Object)"The creation time of the license is illegal");
                    return ResponseFactory.genErrorCodeResult(ResultCodeEnum.CURRENT_TIME_BEFORE_CREATE, "The creation time of the license is illegal");
                }
            }
            catch (ParseException e2) {
                log.error((Object)("validate [" + createDate + "] failed by " + e2.getMessage()), (Throwable)e2);
                return ResponseFactory.genExceptionResult(e2.getMessage());
            }
        }
        return ResponseFactory.genSuccessResult();
    }
}

