/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.utils.DateUtils;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndDateValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(EndDateValidatorValve.class);
    private int buffer_days = 10;

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        String endDate = license.getEndDate();
        if (endDate == null || endDate.length() == 0 || "-1".equals(endDate)) {
            return ResponseFactory.genSuccessResult();
        }
        try {
            if (DateUtils.isAfterBuffer(endDate, this.buffer_days, "yyyy-MM-dd")) {
                log.fatal((Object)("TongWeb valid failure by expired. endDate : " + endDate));
                return ResponseFactory.genErrorCodeResult(ResultCodeEnum.LICENSE_EXPIRED, "TongWeb valid failure by expired. endDate : " + endDate);
            }
            if (DateUtils.isBeforeNow(endDate, "yyyy-MM-dd")) {
                long remainDays = DateUtils.distanceTodayDays(endDate);
                return ResponseFactory.genExpiredLessBuffDay("Remaining service days of the product: " + remainDays + ".The product is about to expire\uff01");
            }
            if (DateUtils.isAfterBuffer(endDate, -15, "yyyy-MM-dd")) {
                long remainDays = DateUtils.distanceTodayDays(endDate);
                return ResponseFactory.genSuccessResponse(ResultCodeEnum.NEAR_EXPIRED, "Remaining service days of the product: " + remainDays);
            }
        }
        catch (ParseException e2) {
            log.error((Object)("validate [" + endDate + "] failed by " + e2.getMessage()), (Throwable)e2);
            return ResponseFactory.genExceptionResult(e2.getMessage());
        }
        return ResponseFactory.genSuccessResult();
    }

    public int getBufferDays() {
        return this.buffer_days;
    }

    public void setBufferDays(int buffer_days) {
        this.buffer_days = buffer_days;
    }
}

