/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.utils.IPUtils;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPMatchValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(IPMatchValidatorValve.class);

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        boolean ipMatch = false;
        String validIps = license.getIpAddress();
        try {
            if (validIps == null || validIps.isEmpty()) {
                return ResponseFactory.genSuccessResult();
            }
            String[] validates = validIps.split(",");
            List<String> ips = IPUtils.getLocalIp();
            if (ips.size() == 0) {
                log.fatal((Object)"Get TongWeb Ip Info fail, when check ip match.");
                return ResponseFactory.genErrorCodeResult(ResultCodeEnum.GET_TONGWEB_IP_ERROR, "Get TongWeb Ip Info fail, when check ip match.");
            }
            for (String validIp : validates) {
                validIp = validIp.trim().toLowerCase();
                for (String localIp : ips) {
                    if (validIp.contains("*")) {
                        ipMatch = IPUtils.ipMatch(validIp, localIp);
                        if (!ipMatch) continue;
                        return ResponseFactory.genSuccessResult();
                    }
                    if (validIp.contains("-")) {
                        Long lo = IPUtils.ipTolong(InetAddress.getByName(validIp.split("-")[0].trim()));
                        Long hi = IPUtils.ipTolong(InetAddress.getByName(validIp.split("-")[1].trim()));
                        Long ip = IPUtils.ipTolong(InetAddress.getByName(localIp));
                        ipMatch = ip >= lo && ip <= hi;
                        if (!ipMatch) continue;
                        return ResponseFactory.genSuccessResult();
                    }
                    if (!validIp.equals(localIp)) continue;
                    return ResponseFactory.genSuccessResult();
                }
            }
            log.fatal((Object)"The ip info is not match License allow list.");
            return ResponseFactory.genErrorCodeResult(ResultCodeEnum.IP_NO_MATCH, "The ip info is not match License allow list.");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return ResponseFactory.genExceptionResult(e2.getMessage());
        }
    }
}

