/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.utils.IPUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MacAddressValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(MacAddressValidatorValve.class);

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        if (validationContext == null) {
            return ResponseFactory.genSuccessResult();
        }
        String licenseMacs = license.getMacAddress();
        if (licenseMacs == null || licenseMacs.length() == 0) {
            return ResponseFactory.genSuccessResult();
        }
        String validMacs = licenseMacs.trim().toLowerCase().replaceAll("[-:.]", "");
        String[] validates = validMacs.split(",");
        List<String> localMacs = IPUtils.getLocalMacs();
        if (localMacs.size() == 0) {
            log.fatal((Object)"getLocalMac:could not get valid local MacAddrs");
            return ResponseFactory.genErrorCodeResult(ResultCodeEnum.MAC_ADDRESS_NO_MATCH, "getLocalMac:could not get valid local MacAddrs");
        }
        boolean ipMatch = false;
        block0: for (String validMac : validates) {
            for (String localMac : localMacs) {
                if (!(localMac = localMac.trim().toLowerCase()).equals(validMac)) continue;
                ipMatch = true;
                continue block0;
            }
        }
        if (!ipMatch) {
            log.fatal((Object)("Please check local MacAddr and bindmac in the License: " + licenseMacs + " localMacs: " + localMacs));
            return ResponseFactory.genErrorCodeResult(ResultCodeEnum.MAC_ADDRESS_NO_MATCH, "Please check local MacAddr and bindmac in the License: " + licenseMacs + " localMacs: " + localMacs);
        }
        return ResponseFactory.genSuccessResult();
    }
}

